/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.event;

import com.codetaylor.mc.athenaeum.util.EnchantmentHelper;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.capability.CapabilityFocused;
import com.codetaylor.mc.pyrotech.modules.tech.basic.capability.FocusedPlayerData;
import com.codetaylor.mc.pyrotech.modules.tech.basic.capability.IFocusedPlayerData;
import com.codetaylor.mc.pyrotech.modules.tech.basic.network.SCPacketCapabilitySyncFocused;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class CampfireFocusEffectEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void on(PlayerPickupXpEvent event) {
        if (!ModuleTechBasicConfig.CAMPFIRE_EFFECTS.FOCUSED_EFFECT_ENABLED) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70170_p.field_72995_K || player.field_71090_bL > 0 || !player.func_193076_bZ().containsKey((Object)ModuleTechBasic.Potions.FOCUSED)) {
            return;
        }
        EntityXPOrb orb = event.getOrb();
        if (orb.field_70532_c > 0) {
            return;
        }
        IFocusedPlayerData data = CapabilityFocused.get(player);
        int xpValue = orb.func_70526_d();
        int experienceToNextLevel = EnchantmentHelper.getExperienceToNextLevel((int)player.field_71068_ca);
        int additionalXP = (int)((double)xpValue * Math.max(0.0, ModuleTechBasicConfig.CAMPFIRE_EFFECTS.FOCUSED_BONUS));
        orb.field_70530_e = xpValue += additionalXP;
        double toReduceBy = (double)xpValue / (double)experienceToNextLevel;
        double remainingBonus = data.getRemainingBonus() - toReduceBy;
        if (remainingBonus > 0.0) {
            data.setRemainingBonus(remainingBonus);
        } else {
            player.func_184589_d((Potion)ModuleTechBasic.Potions.FOCUSED);
        }
        if (ModuleTechBasicConfig.CAMPFIRE_EFFECTS.DEBUG) {
            String message = "Gained additional XP from bonus: " + additionalXP;
            ModuleCore.LOGGER.debug(message);
            player.func_145747_a((ITextComponent)new TextComponentString(message));
        }
    }

    @SubscribeEvent
    public void on(TickEvent.PlayerTickEvent event) {
        IFocusedPlayerData data;
        if (!ModuleTechBasicConfig.CAMPFIRE_EFFECTS.FOCUSED_EFFECT_ENABLED) {
            return;
        }
        if (event.player.field_70170_p.field_72995_K || event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.player.func_193076_bZ().containsKey((Object)ModuleTechBasic.Potions.FOCUSED) && (data = (IFocusedPlayerData)event.player.getCapability(CapabilityFocused.FOCUSED, null)) != null && data.isDirty()) {
            data.setDirty(false);
            ModuleTechBasic.PACKET_SERVICE.sendTo((IMessage)new SCPacketCapabilitySyncFocused(data), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void on(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof EntityPlayer && !(entity instanceof FakePlayer)) {
            event.addCapability(new ResourceLocation("pyrotech", "focused"), (ICapabilityProvider)new Provider());
        }
    }

    private static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        private FocusedPlayerData data = new FocusedPlayerData();

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityFocused.FOCUSED;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityFocused.FOCUSED) {
                return (T)this.data;
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)this.data.writeNBT(CapabilityFocused.FOCUSED, this.data, null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.data.readNBT(CapabilityFocused.FOCUSED, this.data, null, (NBTBase)nbt);
        }
    }
}

