/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.storage.tile;

import com.codetaylor.mc.athenaeum.integration.gamestages.Stages;
import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.ITileInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.athenaeum.inventory.ObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileEntityDataBase;
import com.codetaylor.mc.athenaeum.util.FacingHelper;
import com.codetaylor.mc.athenaeum.util.OreDictHelper;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.storage.ModuleStorage;
import com.codetaylor.mc.pyrotech.modules.storage.ModuleStorageConfig;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileWoodRack
extends TileEntityDataBase
implements ITileInteractable {
    private StackHandler stackHandler = new StackHandler(9);
    private boolean settlingStacks;
    private Interaction[] interactions;

    public TileWoodRack() {
        super(ModuleStorage.TILE_DATA_SERVICE);
        int i;
        this.stackHandler.addObserver((handler, slot) -> {
            this.settleStacks();
            this.func_70296_d();
        });
        this.registerTileDataForNetwork(new ITileData[]{new TileDataItemStackHandler((ItemStackHandler)this.stackHandler)});
        this.interactions = new Interaction[]{new Interaction(new ItemStackHandler[]{this.stackHandler}, 0), new Interaction(new ItemStackHandler[]{this.stackHandler}, 1), new Interaction(new ItemStackHandler[]{this.stackHandler}, 2), new Interaction(new ItemStackHandler[]{this.stackHandler}, 3), new Interaction(new ItemStackHandler[]{this.stackHandler}, 4), new Interaction(new ItemStackHandler[]{this.stackHandler}, 5), new Interaction(new ItemStackHandler[]{this.stackHandler}, 6), new Interaction(new ItemStackHandler[]{this.stackHandler}, 7), new Interaction(new ItemStackHandler[]{this.stackHandler}, 8)};
        for (i = 0; i < 6; ++i) {
            this.interactions[i].setAbove(this.interactions[i + 3]);
        }
        for (i = 3; i < 9; ++i) {
            this.interactions[i].setBelow(this.interactions[i - 3]);
        }
    }

    public void dropContents() {
        StackHelper.spawnStackHandlerContentsOnTop((World)this.field_145850_b, (ItemStackHandler)this.stackHandler, (BlockPos)this.field_174879_c);
    }

    public StackHandler getStackHandler() {
        return this.stackHandler;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.allowAutomation() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.allowAutomation() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.stackHandler);
        }
        return null;
    }

    protected boolean allowAutomation() {
        return ModuleStorageConfig.WOOD_RACK.ALLOW_AUTOMATION;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    private void settleStacks() {
        if (this.settlingStacks || this.field_145850_b.field_72995_K) {
            return;
        }
        this.settlingStacks = true;
        for (int i = 0; i < 6; ++i) {
            int slotLimitAbove = this.stackHandler.getSlotLimit(i + 3);
            ItemStack stackAbove = this.stackHandler.extractItem(i + 3, slotLimitAbove, false);
            stackAbove = this.stackHandler.insertItem(i, stackAbove, false);
            this.stackHandler.insertItem(i + 3, stackAbove, false);
        }
        this.settlingStacks = false;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.stackHandler.deserializeNBT(compound.func_74775_l("stackHandler"));
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("stackHandler", (NBTBase)this.stackHandler.serializeNBT());
        return compound;
    }

    @Nullable
    public Stages getStages() {
        return ModuleStorageConfig.STAGES_WOOD_RACK;
    }

    public IInteraction[] getInteractions() {
        return this.interactions;
    }

    public EnumFacing getTileFacing(World world, BlockPos pos, IBlockState blockState) {
        if (blockState.func_177230_c() == ModuleStorage.Blocks.WOOD_RACK) {
            return (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        }
        return super.getTileFacing(world, pos, blockState);
    }

    private class StackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        StackHandler(int size) {
            super(size);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!OreDictHelper.contains((String)"logWood", (ItemStack)stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    }

    private static class Interaction
    extends InteractionItemStack {
        private static final Vec3d TEXT_OFFSET_NORTH = new Vec3d(0.0, 0.0, -0.5);
        private static final Vec3d TEXT_OFFSET_SOUTH = new Vec3d(0.0, 0.0, 0.5);
        private InteractionItemStack below;
        private InteractionItemStack above;

        public Interaction(ItemStackHandler[] stackHandlers, int slot) {
            super(stackHandlers, slot, EnumFacing.field_82609_l, Interaction.createInteractionBounds(slot, 3), Interaction.createTransform(slot, 3));
        }

        public void setBelow(InteractionItemStack below) {
            this.below = below;
        }

        public void setAbove(InteractionItemStack above) {
            this.above = above;
        }

        private static AxisAlignedBB createInteractionBounds(int slot, int slotCount) {
            int x = slot % slotCount;
            int y = slot / slotCount;
            double opening = 0.625;
            double size = opening / (double)slotCount;
            return new AxisAlignedBB((double)x * size + 0.1875, (double)y * size + 0.25, 0.0625, (double)x * size + size + 0.1875, (double)y * size + size + 0.25, 0.9375);
        }

        private static Transform createTransform(int slot, int slotCount) {
            int x = slot % slotCount;
            int y = slot / slotCount;
            double opening = 0.625;
            double size = opening / (double)slotCount;
            return new Transform(Transform.translate((double)((double)x * size + size / 2.0 + 0.1875), (double)((double)y * size + size / 2.0 + 0.25), (double)0.5), Transform.rotate((double)1.0, (double)0.0, (double)0.0, (double)90.0), Transform.scale((double)size, (double)0.875, (double)size));
        }

        public boolean isEnabled() {
            if (this.isEmpty()) {
                if (this.below == null) {
                    return true;
                }
                ItemStack stackInSlot = this.below.getStackInSlot();
                if (stackInSlot.func_190916_E() == stackInSlot.func_77976_d()) {
                    return true;
                }
                return true;
            }
            return true;
        }

        public Vec3d getTextOffset(EnumFacing tileFacing, EnumFacing playerHorizontalFacing, EnumFacing sideHit) {
            EnumFacing actualSideHit = FacingHelper.translateFacing((EnumFacing)tileFacing, (EnumFacing)sideHit);
            if (actualSideHit == EnumFacing.NORTH) {
                return TEXT_OFFSET_NORTH;
            }
            if (actualSideHit == EnumFacing.SOUTH) {
                return TEXT_OFFSET_SOUTH;
            }
            return null;
        }

        protected boolean doItemStackValidation(ItemStack itemStack) {
            if (!OreDictHelper.contains((String)"logWood", (ItemStack)itemStack)) {
                return false;
            }
            if (this.isEmpty() && this.below != null) {
                if (this.below.isEmpty()) {
                    return false;
                }
                ItemStack remaining = this.below.insert(itemStack, true);
                if (itemStack.func_190916_E() > remaining.func_190916_E()) {
                    return false;
                }
            }
            return true;
        }

        protected void onInsert(IInteraction.EnumType type, ItemStack itemStack, World world, EntityPlayer player, BlockPos pos) {
            super.onInsert(type, itemStack, world, player, pos);
            if (!world.field_72995_K && type == IInteraction.EnumType.MouseClick) {
                world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 0.75f, (float)(1.0 + Util.RANDOM.nextGaussian() * (double)0.4f));
            }
        }
    }
}

