/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.storage.plugin.waila.delegate;

import com.codetaylor.mc.pyrotech.Reference;
import com.codetaylor.mc.pyrotech.library.waila.ProviderDelegateBase;
import com.codetaylor.mc.pyrotech.modules.storage.tile.spi.TileBagBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.StringUtils;

public class BagProviderDelegate
extends ProviderDelegateBase<IBagDisplay, TileBagBase> {
    private EntityPlayer player;

    public BagProviderDelegate(IBagDisplay display) {
        super(display);
    }

    public void setPlayer(EntityPlayer player) {
        this.player = player;
    }

    @Override
    public void display(TileBagBase tile) {
        ItemStack stackInSlot;
        TileBagBase.StackHandler stackHandler = tile.getStackHandler();
        int maxDigits = 0;
        if (tile.isOpen()) {
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                int count;
                int digits;
                stackInSlot = stackHandler.getStackInSlot(i);
                if (stackInSlot.func_190926_b() || (digits = String.valueOf(count = stackInSlot.func_190916_E()).length()) <= maxDigits) continue;
                maxDigits = digits;
            }
            ((IBagDisplay)this.display).setContents((ItemStackHandler)stackHandler);
        }
        String langKey = "gui.pyrotech.waila.capacity";
        ((IBagDisplay)this.display).setItemCount(langKey, tile.getItemCount(), tile.getItemCapacity());
        if (tile.isOpen()) {
            if (this.player.func_70093_af()) {
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    stackInSlot = stackHandler.getStackInSlot(i);
                    if (stackInSlot.func_190926_b()) continue;
                    String count = String.valueOf(stackInSlot.func_190916_E());
                    count = count.length() < maxDigits ? TextFormatting.DARK_GRAY + StringUtils.repeat((String)"0", (int)(maxDigits - count.length())).concat(TextFormatting.YELLOW + count) : TextFormatting.YELLOW + count;
                    ((IBagDisplay)this.display).setExtendedInfoOn(" " + count + " ", TextFormatting.GOLD, stackInSlot);
                }
            } else {
                langKey = "gui.pyrotech.tooltip.extended.shift";
                ((IBagDisplay)this.display).setExtendedInfoOff(langKey, Reference.Tooltip.COLOR_EXTENDED_INFO, TextFormatting.GRAY);
            }
        }
    }

    public static interface IBagDisplay {
        public void setContents(ItemStackHandler var1);

        public void setItemCount(String var1, int var2, int var3);

        public void setExtendedInfoOff(String var1, TextFormatting var2, TextFormatting var3);

        public void setExtendedInfoOn(String var1, TextFormatting var2, ItemStack var3);
    }
}

