/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.storage.event;

import com.codetaylor.mc.athenaeum.util.SoundHelper;
import com.codetaylor.mc.pyrotech.modules.storage.block.item.ItemBlockBag;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

@Mod.EventBusSubscriber
public class EntityItemPickupEventHandler {
    private final List<IBagLocator> bagLocatorList = new ArrayList<IBagLocator>(4);

    public EntityItemPickupEventHandler() {
        this.bagLocatorList.add((player, result) -> {
            ItemStack heldItemStack = player.func_184614_ca();
            Item heldItem = heldItemStack.func_77973_b();
            if (heldItem instanceof ItemBlockBag && ((ItemBlockBag)heldItem).allowAutoPickupMainhand() && ((ItemBlockBag)heldItem).isOpen(heldItemStack)) {
                result.add(new BagHandler(heldItemStack));
            }
        });
        this.bagLocatorList.add((player, result) -> {
            ItemStack heldItemStack = player.func_184592_cb();
            Item heldItem = heldItemStack.func_77973_b();
            if (heldItem instanceof ItemBlockBag && ((ItemBlockBag)heldItem).allowAutoPickupOffhand() && ((ItemBlockBag)heldItem).isOpen(heldItemStack)) {
                result.add(new BagHandler(heldItemStack));
            }
        });
        this.bagLocatorList.add((player, result) -> {
            for (int i = 0; i < 9; ++i) {
                ItemStack itemStack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                Item item = itemStack.func_77973_b();
                if (!(item instanceof ItemBlockBag) || !((ItemBlockBag)item).allowAutoPickupHotbar() || !((ItemBlockBag)item).isOpen(itemStack)) continue;
                result.add(new BagHandler(itemStack));
            }
        });
        this.bagLocatorList.add((player, result) -> {
            for (int i = 10; i < 36; ++i) {
                ItemStack itemStack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                Item item = itemStack.func_77973_b();
                if (!(item instanceof ItemBlockBag) || !((ItemBlockBag)item).allowAutoPickupInventory() || !((ItemBlockBag)item).isOpen(itemStack)) continue;
                result.add(new BagHandler(itemStack));
            }
        });
    }

    @SubscribeEvent
    public void on(EntityItemPickupEvent event) {
        ItemStack remainingItems;
        EntityPlayer entityPlayer = event.getEntityPlayer();
        if (entityPlayer.field_70170_p.field_72995_K) {
            return;
        }
        List<BagHandler> handlers = this.locateBags(entityPlayer);
        if (handlers.isEmpty()) {
            return;
        }
        EntityItem entityItem = event.getItem();
        ItemStack itemStack = entityItem.func_92059_d();
        boolean interested = false;
        for (BagHandler handler : handlers) {
            remainingItems = handler.insert(itemStack, true);
            int remainingItemsCount = remainingItems.func_190916_E();
            if (remainingItemsCount == itemStack.func_190916_E()) continue;
            interested = true;
            break;
        }
        if (!interested) {
            return;
        }
        PlayerMainInvWrapper inventory = new PlayerMainInvWrapper(entityPlayer.field_71071_by);
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (inventory.getStackInSlot(i).func_190926_b()) continue;
            remainingItems = inventory.insertItem(i, itemStack, false);
            if (remainingItems.func_190916_E() != itemStack.func_190916_E()) {
                itemStack.func_190920_e(remainingItems.func_190916_E());
            }
            if (remainingItems.func_190916_E() != 0) continue;
            return;
        }
        for (BagHandler handler : handlers) {
            ItemStack remainingItems2 = handler.insert(itemStack, false);
            int remainingItemsCount = remainingItems2.func_190916_E();
            if (remainingItemsCount != itemStack.func_190916_E()) {
                SoundHelper.playSoundServer((World)entityPlayer.field_70170_p, (BlockPos)entityPlayer.func_180425_c(), (SoundEvent)SoundEvents.field_187638_cR, (SoundCategory)SoundCategory.PLAYERS, (float)0.4f, (float)SoundHelper.getPitchEntityItemPickup());
            }
            itemStack.func_190920_e(remainingItemsCount);
            if (remainingItemsCount != 0) continue;
            break;
        }
    }

    private List<BagHandler> locateBags(EntityPlayer player) {
        ArrayList<BagHandler> result = new ArrayList<BagHandler>(4);
        for (IBagLocator locator : this.bagLocatorList) {
            locator.locateBags(player, result);
        }
        return result;
    }

    private static class BagHandler {
        private final ItemStack bagItemStack;

        BagHandler(ItemStack bagItemStack) {
            this.bagItemStack = bagItemStack;
        }

        ItemStack insert(ItemStack itemStack, boolean simulate) {
            ItemBlockBag bagItem = (ItemBlockBag)this.bagItemStack.func_77973_b();
            if (bagItem.isItemValidForInsertion(itemStack)) {
                return ItemBlockBag.insertItem(this.bagItemStack, itemStack, simulate);
            }
            return itemStack;
        }
    }

    private static interface IBagLocator {
        public void locateBags(EntityPlayer var1, List<BagHandler> var2);
    }
}

