/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.storage.block.spi;

import com.codetaylor.mc.athenaeum.interaction.spi.IBlockInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.spi.BlockPartialBase;
import com.codetaylor.mc.athenaeum.spi.IVariant;
import com.codetaylor.mc.athenaeum.util.AABBHelper;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.pyrotech.modules.storage.tile.TileShelf;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockShelfBase
extends BlockPartialBase
implements IBlockInteractable {
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);
    private static final Map<EnumFacing, Map<EnumType, AxisAlignedBB>> AABB;

    public BlockShelfBase(float hardness, float resistance) {
        super(Material.field_151575_d);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)EnumFacing.NORTH).func_177226_a(TYPE, (Comparable)((Object)EnumType.BACK)));
        this.func_149672_a(SoundType.field_185848_a);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        return this.interactionRayTrace(super.func_180636_a(blockState, world, pos, start, end), blockState, world, pos, start, end);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.interact(IInteraction.EnumType.MouseClick, world, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof TileShelf) {
            ((TileShelf)tileEntity).dropContents();
        }
        super.func_180663_b(world, pos, state);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing playerFacing = placer.func_174811_aO();
        EnumFacing opposite = playerFacing.func_176734_d();
        EnumType type = EnumType.BACK;
        if (facing != opposite && facing != playerFacing) {
            if (playerFacing == EnumFacing.SOUTH && (double)hitZ < 0.5) {
                type = EnumType.FORWARD;
            } else if (playerFacing == EnumFacing.NORTH && (double)hitZ > 0.5) {
                type = EnumType.FORWARD;
            } else if (playerFacing == EnumFacing.EAST && (double)hitX < 0.5) {
                type = EnumType.FORWARD;
            } else if (playerFacing == EnumFacing.WEST && (double)hitX > 0.5) {
                type = EnumType.FORWARD;
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)opposite).func_177226_a(TYPE, (Comparable)((Object)type));
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        EnumType type = (EnumType)((Object)state.func_177229_b(TYPE));
        return AABB.get(facing).get((Object)type);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return this.createTileEntity();
    }

    protected abstract TileEntity createTileEntity();

    public boolean isSideSolid(IBlockState base_state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        return false;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Properties.FACING_HORIZONTAL, TYPE});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.fromMeta(meta >> 2 & 1))).func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)EnumFacing.field_176754_o[meta & 3]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getMeta() << 2 | ((EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL)).func_176736_b();
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    static {
        AxisAlignedBB Z_POS = AABBHelper.create((double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0, (double)16.0);
        AxisAlignedBB Z_NEG = AABBHelper.create((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)6.0);
        AxisAlignedBB X_POS = AABBHelper.create((double)0.0, (double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0);
        AxisAlignedBB X_NEG = AABBHelper.create((double)10.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        AABB = Stream.of(EnumFacing.field_176754_o).collect(Collectors.toMap(facing -> facing, facing -> {
            EnumMap<EnumType, AxisAlignedBB> map = new EnumMap<EnumType, AxisAlignedBB>(EnumType.class);
            if (facing == EnumFacing.NORTH) {
                map.put(EnumType.BACK, Z_POS);
                map.put(EnumType.FORWARD, Z_NEG);
            } else if (facing == EnumFacing.SOUTH) {
                map.put(EnumType.BACK, Z_NEG);
                map.put(EnumType.FORWARD, Z_POS);
            } else if (facing == EnumFacing.EAST) {
                map.put(EnumType.BACK, X_POS);
                map.put(EnumType.FORWARD, X_NEG);
            } else if (facing == EnumFacing.WEST) {
                map.put(EnumType.BACK, X_NEG);
                map.put(EnumType.FORWARD, X_POS);
            }
            return map;
        }, (u, v) -> {
            throw new IllegalStateException();
        }, () -> new EnumMap(EnumFacing.class)));
    }

    public static enum EnumType implements IVariant
    {
        BACK(0, "back"),
        FORWARD(1, "forward");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public static EnumType fromMeta(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = (EnumType[])Stream.of(EnumType.values()).sorted(Comparator.comparing(EnumType::getMeta)).toArray(EnumType[]::new);
        }
    }
}

