/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.storage.block.spi;

import com.codetaylor.mc.athenaeum.interaction.spi.IBlockInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.spi.BlockPartialBase;
import com.codetaylor.mc.athenaeum.util.AABBHelper;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.pyrotech.modules.storage.tile.spi.TileFaucetBase;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public abstract class BlockFaucetBase
extends BlockPartialBase
implements IBlockInteractable {
    private static final AxisAlignedBB AABB_NORTH = AABBHelper.create((double)4.0, (double)4.0, (double)10.0, (double)12.0, (double)10.0, (double)16.0);
    private static final AxisAlignedBB AABB_SOUTH = AABBHelper.create((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)10.0, (double)6.0);
    private static final AxisAlignedBB AABB_EAST = AABBHelper.create((double)0.0, (double)4.0, (double)4.0, (double)6.0, (double)10.0, (double)12.0);
    private static final AxisAlignedBB AABB_WEST = AABBHelper.create((double)10.0, (double)4.0, (double)4.0, (double)16.0, (double)10.0, (double)12.0);

    public BlockFaucetBase() {
        super(Material.field_151576_e);
        this.func_149752_b(2.5f);
        this.func_149711_c(1.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)EnumFacing.NORTH));
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 0);
    }

    protected abstract boolean canTransferHotFluids();

    protected abstract int getTransferLimit();

    protected abstract int getTransferAmountPerTick();

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        return this.interactionRayTrace(super.func_180636_a(blockState, world, pos, start, end), blockState, world, pos, start, end);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.interact(IInteraction.EnumType.MouseClick, world, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public boolean func_176198_a(@Nonnull World world, @Nonnull BlockPos pos, EnumFacing side) {
        TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(side.func_176734_d()));
        if (tileEntity == null) {
            return false;
        }
        if (!tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
            return false;
        }
        return super.func_176198_a(world, pos, side);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (facing.func_176736_b() > -1) {
            return this.func_176223_P().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)facing);
        }
        return this.func_176223_P().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)EnumFacing.NORTH);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        switch (facing) {
            case NORTH: {
                return AABB_NORTH;
            }
            case SOUTH: {
                return AABB_SOUTH;
            }
            case EAST: {
                return AABB_EAST;
            }
            case WEST: {
                return AABB_WEST;
            }
        }
        throw new IllegalStateException();
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tileEntity;
        if (world.field_72995_K) {
            return;
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        if (world.func_175623_d(pos.func_177972_a(facing.func_176734_d()))) {
            world.func_175655_b(pos, true);
            return;
        }
        if (world.func_175640_z(pos) && (tileEntity = world.func_175625_s(pos)) instanceof TileFaucetBase) {
            ((TileFaucetBase)tileEntity).setActive(true);
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return this.createTileEntity();
    }

    protected abstract TileEntity createTileEntity();

    public void func_190948_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flag) {
        int rate = this.getTransferAmountPerTick();
        tooltip.add(I18n.func_74837_a((String)"gui.pyrotech.tooltip.fluid.transfer.rate", (Object[])new Object[]{rate}));
        int limit = this.getTransferLimit();
        if (limit > -1) {
            tooltip.add(I18n.func_74837_a((String)"gui.pyrotech.tooltip.fluid.transfer.limit", (Object[])new Object[]{limit}));
        }
        boolean hotFluids = this.canTransferHotFluids();
        tooltip.add((hotFluids ? TextFormatting.GREEN : TextFormatting.RED) + I18n.func_74837_a((String)("gui.pyrotech.tooltip.hot.fluids." + hotFluids), (Object[])new Object[0]));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Properties.FACING_HORIZONTAL});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)EnumFacing.field_176754_o[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL)).func_176736_b();
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }
}

