/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.storage.block.item;

import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.modules.storage.block.spi.BlockTankBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class ItemBlockTank
extends ItemBlock {
    private final BlockTankBase block;

    public ItemBlockTank(BlockTankBase block) {
        super((Block)block);
        this.block = block;
    }

    @ParametersAreNonnullByDefault
    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!world.func_180501_a(pos, newState, 11)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this.block) {
            ItemBlockTank.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
            this.block.onBlockPlacedBy(world, pos, state, (EntityLivingBase)player, stack, side);
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
            }
        }
        return true;
    }

    @ParametersAreNonnullByDefault
    public static void writeTank(FluidTank tank, ItemStack itemStack) {
        tank.writeToNBT(ItemBlockTank.getTankTagSafe(itemStack));
    }

    @ParametersAreNonnullByDefault
    public static void readTank(FluidTank tank, ItemStack itemStack) {
        tank.readFromNBT(ItemBlockTank.getTankTagSafe(itemStack));
    }

    @Nullable
    public static NBTTagCompound getTankTag(@Nonnull ItemStack itemStack) {
        return itemStack.func_77978_p();
    }

    @Nonnull
    public static NBTTagCompound getTankTagSafe(@Nonnull ItemStack itemStack) {
        return StackHelper.getTagSafe((ItemStack)itemStack);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new TankFluidCapability(stack, this.block.getCapacity());
    }

    private static class TankFluidCapability
    extends FluidHandlerItemStack {
        public TankFluidCapability(@Nonnull ItemStack container, int capacity) {
            super(container, capacity);
        }

        protected void setFluid(FluidStack fluid) {
            NBTTagCompound tankTag = ItemBlockTank.getTankTagSafe(this.container);
            tankTag.func_82580_o("Empty");
            fluid.writeToNBT(tankTag);
        }

        @Nullable
        public FluidStack getFluid() {
            NBTTagCompound tankTag = ItemBlockTank.getTankTag(this.container);
            if (tankTag == null || tankTag.func_74764_b("Empty")) {
                return null;
            }
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tankTag);
        }

        protected void setContainerToEmpty() {
            NBTTagCompound tankTag = ItemBlockTank.getTankTagSafe(this.container);
            tankTag.func_74778_a("Empty", "");
            tankTag.func_82580_o("FluidName");
            tankTag.func_82580_o("Amount");
            tankTag.func_82580_o("Tag");
        }
    }
}

