/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.plugin.patchouli.processors;

import com.codetaylor.mc.pyrotech.modules.plugin.patchouli.processors.TimedRecipeProcessorBase;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.ModuleTechRefractory;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.recipe.PitBurnRecipe;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import vazkii.patchouli.common.util.ItemStackUtil;

public class PitBurnRecipeProcessor
extends TimedRecipeProcessorBase<PitBurnRecipe> {
    @Override
    @Nullable
    protected PitBurnRecipe getRecipe(ResourceLocation key) {
        return (PitBurnRecipe)ModuleTechRefractory.Registries.BURN_RECIPE.getValue(key);
    }

    @Override
    public String process(String key) {
        if (this.recipe != null) {
            if ("input".equals(key)) {
                Block block = ((PitBurnRecipe)this.recipe).getInputMatcher().getBlock();
                ItemStack itemStack = new ItemStack(block);
                return ItemStackUtil.serializeIngredient((Ingredient)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{itemStack}));
            }
            if ("output".equals(key)) {
                ItemStack output = ((PitBurnRecipe)this.recipe).getOutput().func_77946_l();
                output.func_190920_e(((PitBurnRecipe)this.recipe).getBurnStages());
                return ItemStackUtil.serializeStack((ItemStack)output);
            }
            if ("failure_items".equals(key)) {
                ItemStack[] failureItems = ((PitBurnRecipe)this.recipe).getFailureItems();
                return ItemStackUtil.serializeIngredient((Ingredient)Ingredient.func_193369_a((ItemStack[])failureItems));
            }
            if ("fluid".equals(key)) {
                FluidStack fluidProduced = ((PitBurnRecipe)this.recipe).getFluidProduced();
                if (fluidProduced != null) {
                    return fluidProduced.getFluid().getName();
                }
            } else if ("fluid_name".equals(key)) {
                FluidStack fluidProduced = ((PitBurnRecipe)this.recipe).getFluidProduced();
                if (fluidProduced != null) {
                    return fluidProduced.getLocalizedName();
                }
            } else if ("fluid_amount".equals(key)) {
                FluidStack fluidProduced = ((PitBurnRecipe)this.recipe).getFluidProduced();
                if (fluidProduced != null) {
                    return String.valueOf(fluidProduced.amount * ((PitBurnRecipe)this.recipe).getBurnStages());
                }
            } else if ("refractory_only".equals(key)) {
                return String.valueOf(((PitBurnRecipe)this.recipe).requiresRefractoryBlocks());
            }
        }
        return super.process(key);
    }
}

