/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.patreon.effect;

import com.codetaylor.mc.pyrotech.library.particle.ParticleEmitter;
import com.codetaylor.mc.pyrotech.library.particle.ParticleFactoryAdapter;
import com.codetaylor.mc.pyrotech.library.patreon.effect.EffectBase;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.patreon.ModulePatreonConfig;
import com.codetaylor.mc.pyrotech.modules.patreon.PlayerEntityTracker;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleFlame;
import net.minecraft.client.particle.ParticleSmokeNormal;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EffectHothead
extends EffectBase {
    private static MethodHandle renderPlayer$smallArmsGetter;
    private static final Map<UUID, RenderPlayer> RENDERERS;

    public EffectHothead(UUID uuid) {
        super(uuid);
    }

    @Override
    public boolean subscribeEvents() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void on(RenderPlayerEvent.Pre event) {
        EntityPlayer entityForPlayer;
        if (renderPlayer$smallArmsGetter == null) {
            try {
                renderPlayer$smallArmsGetter = MethodHandles.lookup().unreflectGetter(ObfuscationReflectionHelper.findField(RenderPlayer.class, (String)"field_177140_a"));
            }
            catch (Exception e) {
                ModuleCore.LOGGER.error("", (Throwable)e);
            }
        }
        if (event.getRenderer() instanceof RenderPlayerHothead) {
            return;
        }
        if (renderPlayer$smallArmsGetter == null) {
            return;
        }
        UUID uuid = event.getEntityPlayer().func_110124_au();
        if (uuid.equals(this.getUuid()) && (entityForPlayer = PlayerEntityTracker.getEntityForPlayer(uuid)) != null) {
            try {
                RenderPlayer renderPlayer = RENDERERS.get(uuid);
                if (renderPlayer == null) {
                    boolean smallArms = renderPlayer$smallArmsGetter.invokeExact(event.getRenderer());
                    renderPlayer = new RenderPlayerHothead(Minecraft.func_71410_x().func_175598_ae(), smallArms);
                    RENDERERS.put(uuid, renderPlayer);
                }
                renderPlayer.func_76986_a((AbstractClientPlayer)event.getEntityPlayer(), event.getX(), event.getY(), event.getZ(), event.getEntity().field_70177_z, event.getPartialRenderTick());
                event.setCanceled(true);
            }
            catch (Throwable throwable) {
                ModuleCore.LOGGER.error("", throwable);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void on(TickEvent.ClientTickEvent event) {
        if (renderPlayer$smallArmsGetter == null) {
            return;
        }
        if (ModulePatreonConfig.CLIENT.DISABLE_ALL_PATREON_EFFECTS) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            Minecraft minecraft = Minecraft.func_71410_x();
            WorldClient world = minecraft.field_71441_e;
            if (minecraft.func_147113_T()) {
                return;
            }
            UUID uuid = this.getUuid();
            if (ModulePatreonConfig.CLIENT.DISABLE_YOUR_PATREON_EFFECTS) {
                EntityPlayerSP player = minecraft.field_71439_g;
                if (player == null) {
                    return;
                }
                UUID uniqueID = player.func_110124_au();
                if (uuid.equals(uniqueID)) {
                    return;
                }
            }
            if (world != null) {
                if (world.func_82737_E() % 4L != 0L) {
                    return;
                }
                EntityPlayer entity = PlayerEntityTracker.getEntityForPlayer(uuid);
                if (entity == null) {
                    return;
                }
                double offsetY = 2.0;
                if (entity.func_70608_bn()) {
                    offsetY = 0.0;
                } else if (entity.func_70093_af()) {
                    offsetY = 1.625;
                }
                if (entity.func_70090_H()) {
                    minecraft.field_71452_i.func_78873_a((Particle)new ParticleEmitter((World)world, new Vec3d(entity.field_70165_t, entity.field_70163_u + offsetY, entity.field_70161_v), new Vec3d(0.25, 0.0125, 0.25), 15, 40, new ParticleFactoryAdapter((IParticleFactory)new ParticleSmokeNormal.Factory())));
                } else {
                    minecraft.field_71452_i.func_78873_a((Particle)new ParticleEmitter((World)world, new Vec3d(entity.field_70165_t, entity.field_70163_u + offsetY, entity.field_70161_v), new Vec3d(0.25, 0.0125, 0.25), entity.func_70051_ag() ? 2 : 15, entity.func_70051_ag() ? 80 : 40, new ParticleFactoryAdapter((IParticleFactory)new ParticleFlame.Factory())));
                }
            }
        }
    }

    static {
        RENDERERS = new HashMap<UUID, RenderPlayer>();
    }

    @SideOnly(value=Side.CLIENT)
    public static class HotheadLayer
    implements LayerRenderer<EntityPlayer> {
        private final ModelRenderer modelRenderer;
        private World world;
        private EntityMagmaCube entityMagmaCube;

        public HotheadLayer(ModelRenderer modelRenderer) {
            this.modelRenderer = modelRenderer;
        }

        public void doRenderLayer(@Nonnull EntityPlayer entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (ModulePatreonConfig.CLIENT.DISABLE_ALL_PATREON_EFFECTS) {
                return;
            }
            UUID uuid = entity.func_110124_au();
            Minecraft minecraft = Minecraft.func_71410_x();
            if (ModulePatreonConfig.CLIENT.DISABLE_YOUR_PATREON_EFFECTS) {
                EntityPlayerSP player = minecraft.field_71439_g;
                if (player == null) {
                    return;
                }
                UUID uniqueID = player.func_110124_au();
                if (uuid.equals(uniqueID)) {
                    return;
                }
            }
            if (this.world == null) {
                this.world = entity.field_70170_p;
            }
            if (this.entityMagmaCube == null || this.world != entity.field_70170_p) {
                this.world = entity.field_70170_p;
                this.entityMagmaCube = new EntityMagmaCube(this.world);
            }
            GlStateManager.func_179094_E();
            if (entity.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            }
            this.modelRenderer.func_78794_c(0.0625f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float scalar = 0.95f;
            GlStateManager.func_179152_a((float)(1.1875f * scalar), (float)(-1.1875f * scalar), (float)(-1.1875f * scalar));
            RenderLivingBase render = (RenderLivingBase)minecraft.func_175598_ae().field_78729_o.get(EntityMagmaCube.class);
            render.func_76986_a((EntityLivingBase)this.entityMagmaCube, 0.0, -0.025, 0.0, netHeadYaw, partialTicks);
            GlStateManager.func_179121_F();
        }

        public boolean func_177142_b() {
            return false;
        }
    }

    private static class RenderPlayerHothead
    extends RenderPlayer {
        public RenderPlayerHothead(RenderManager renderManager, boolean smallArms) {
            super(renderManager, smallArms);
            this.func_177094_a(new HotheadLayer(this.func_177087_b().field_78116_c));
        }
    }
}

