/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.hunting.tile;

import com.codetaylor.mc.athenaeum.integration.gamestages.Stages;
import com.codetaylor.mc.athenaeum.interaction.api.InteractionBounds;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.ITileInteractable;
import com.codetaylor.mc.athenaeum.inventory.DynamicStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFloat;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataLargeItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileEntityDataBase;
import com.codetaylor.mc.athenaeum.util.ArrayHelper;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.hunting.ModuleHuntingConfig;
import com.codetaylor.mc.pyrotech.modules.hunting.tile.InteractionCarcass;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.ItemStackHandler;

public class TileCarcass
extends TileEntityDataBase
implements ITileInteractable {
    private final StackHandler stackHandler;
    private final TileDataFloat currentProgress = new TileDataFloat(0.0f);
    private final TileDataFloat totalProgress = new TileDataFloat(0.0f);
    private final IInteraction<?>[] interactions;

    public TileCarcass() {
        super(ModuleCore.TILE_DATA_SERVICE);
        this.stackHandler = new StackHandler();
        this.stackHandler.addObserver((handler, slot) -> {
            this.resetProgress();
            this.func_70296_d();
        });
        this.registerTileDataForNetwork(new ITileData[]{new TileDataLargeItemStackHandler((ItemStackHandler)this.stackHandler), this.currentProgress, this.totalProgress});
        this.interactions = new IInteraction[]{new InteractionCarcass(EnumFacing.field_82609_l, InteractionBounds.BLOCK, new InteractionInteractionCarcassDelegate(this))};
        this.resetProgress();
    }

    private void resetProgress() {
        int progressRequired = ModuleHuntingConfig.CARCASS.TOTAL_PROGRESS_REQUIRED;
        float adjustment = RandomHelper.random().nextFloat() * 0.2f - 0.1f;
        this.currentProgress.set(Math.max(1.0f, (float)progressRequired + (float)progressRequired * adjustment));
        this.totalProgress.set(this.currentProgress.get());
    }

    public float getCurrentProgress() {
        return 1.0f - this.currentProgress.get() / this.totalProgress.get();
    }

    public ItemStack getNextItem() {
        ItemStack itemStack = this.stackHandler.getFirstNonEmptyItemStack().func_77946_l();
        itemStack.func_190920_e(1);
        return itemStack;
    }

    private int getFirstNonEmptySlot() {
        for (int i = 0; i < this.stackHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.stackHandler.getStackInSlot(i);
            if (stackInSlot.func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("stackHandler", (NBTBase)this.stackHandler.serializeNBT());
        return compound;
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.stackHandler.deserializeNBT(compound.func_74775_l("stackHandler"));
    }

    @Nullable
    public Stages getStages() {
        return ModuleHuntingConfig.STAGES_CARCASS;
    }

    public IInteraction<?>[] getInteractions() {
        return this.interactions;
    }

    private static class StackHandler
    extends DynamicStackHandler
    implements ITileDataItemStackHandler {
        StackHandler() {
            super(1);
        }
    }

    private static class InteractionInteractionCarcassDelegate
    implements InteractionCarcass.IInteractionCarcassDelegate {
        private final TileCarcass tile;

        public InteractionInteractionCarcassDelegate(TileCarcass tile) {
            this.tile = tile;
        }

        @Override
        public boolean canUseWithHungerLevel(int playerFoodLevel) {
            return playerFoodLevel < ModuleHuntingConfig.CARCASS.MINIMUM_HUNGER_TO_USE;
        }

        @Override
        public boolean canUseWithHeldItem(String registryName) {
            return ArrayHelper.contains((Object[])ModuleHuntingConfig.CARCASS.ALLOWED_KNIVES, (Object)registryName);
        }

        @Override
        public void doExhaustion(EntityPlayer player) {
            if (ModuleHuntingConfig.CARCASS.EXHAUSTION_COST_PER_KNIFE_USE > 0.0) {
                player.func_71020_j((float)ModuleHuntingConfig.CARCASS.EXHAUSTION_COST_PER_KNIFE_USE);
            }
        }

        @Override
        public int getItemEfficiency(String registryName) {
            return ModuleHuntingConfig.CARCASS.KNIFE_EFFICIENCY.getOrDefault(registryName, 1);
        }

        @Override
        public void setCurrentProgress(float value) {
            this.tile.currentProgress.set(value);
        }

        @Override
        public float getCurrentProgress() {
            return this.tile.currentProgress.get();
        }

        @Override
        public ItemStack extractItem(ResourceLocation heldItemResourceLocation) {
            int slot = this.tile.getFirstNonEmptySlot();
            return this.tile.stackHandler.extractItem(slot, 1, false);
        }

        @Override
        public BlockPos getPosition() {
            return this.tile.func_174877_v();
        }

        @Override
        public boolean isEmpty() {
            return this.tile.stackHandler.getTotalItemCount() == 0;
        }

        @Override
        public void destroyCarcass() {
            this.tile.field_145850_b.func_175655_b(this.tile.func_174877_v(), false);
        }

        @Override
        public void resetProgress() {
            this.tile.resetProgress();
        }
    }
}

