/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.hunting.tile;

import com.codetaylor.mc.athenaeum.integration.gamestages.Stages;
import com.codetaylor.mc.athenaeum.interaction.api.InteractionBounds;
import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.ITileInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.athenaeum.inventory.ObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFloat;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileEntityDataBase;
import com.codetaylor.mc.athenaeum.parser.recipe.item.ParseResult;
import com.codetaylor.mc.athenaeum.parser.recipe.item.RecipeItemParser;
import com.codetaylor.mc.athenaeum.util.ArrayHelper;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.hunting.ModuleHunting;
import com.codetaylor.mc.pyrotech.modules.hunting.ModuleHuntingConfig;
import com.codetaylor.mc.pyrotech.modules.hunting.item.ItemBlockCarcass;
import com.codetaylor.mc.pyrotech.modules.hunting.tile.InteractionCarcass;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.ItemStackHandler;

public class TileButchersBlock
extends TileEntityDataBase
implements ITileInteractable {
    private final InputStackHandler inputStackHandler;
    private final TileDataFloat currentProgress = new TileDataFloat(0.0f);
    private final TileDataFloat totalProgress = new TileDataFloat(0.0f);
    private final IInteraction<?>[] interactions;
    private AxisAlignedBB renderBounds;

    public TileButchersBlock() {
        super(ModuleCore.TILE_DATA_SERVICE);
        this.inputStackHandler = new InputStackHandler();
        this.inputStackHandler.addObserver((handler, slot) -> {
            this.resetProgress();
            this.func_70296_d();
        });
        this.registerTileDataForNetwork(new ITileData[]{new TileDataItemStackHandler((ItemStackHandler)this.inputStackHandler), this.currentProgress, this.totalProgress});
        this.interactions = new IInteraction[]{new InputInteraction((ItemStackHandler)this.inputStackHandler), new InteractionCarcass(new EnumFacing[]{EnumFacing.UP}, InteractionBounds.BLOCK, new InteractionInteractionCarcassDelegate(this))};
        this.resetProgress();
    }

    private void resetProgress() {
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
            int progressRequired = ModuleHuntingConfig.BUTCHERS_BLOCK.TOTAL_PROGRESS_REQUIRED;
            float adjustment = RandomHelper.random().nextFloat() * 0.2f - 0.1f;
            this.currentProgress.set(Math.max(1.0f, (float)progressRequired + (float)progressRequired * adjustment));
            this.totalProgress.set(this.currentProgress.get());
        }
    }

    private ItemStack transformItem(ResourceLocation heldItemResourceLocation, ItemStack itemStack) {
        Map<String, String> outputTransformers = ArrayHelper.contains((Object[])ModuleHuntingConfig.BUTCHERS_BLOCK.ALLOWED_BUTCHERS_KNIVES, (Object)heldItemResourceLocation.toString()) ? ModuleHuntingConfig.BUTCHERS_BLOCK.BUTCHERS_KNIFE_OUTPUT_TRANSFORMERS : ModuleHuntingConfig.BUTCHERS_BLOCK.HUNTERS_KNIFE_OUTPUT_TRANSFORMERS;
        for (Map.Entry<String, String> entry : outputTransformers.entrySet()) {
            try {
                ParseResult parseResult = RecipeItemParser.INSTANCE.parse(entry.getKey());
                if (!parseResult.matches(itemStack, true)) continue;
                String[] split = entry.getValue().split(";");
                if (split.length != 3) {
                    ModuleHunting.LOGGER.error("Invalid format for output transformer value: " + entry.getValue());
                    continue;
                }
                ParseResult outputParseResult = RecipeItemParser.INSTANCE.parse(split[0]);
                int count = Integer.parseInt(split[1]);
                float chance = Float.parseFloat(split[2]);
                if (!(RandomHelper.random().nextFloat() <= chance)) continue;
                Item item = Item.func_111206_d((String)(outputParseResult.getDomain() + ":" + outputParseResult.getPath()));
                if (item == null) {
                    ModuleHunting.LOGGER.error("Invalid item for output transformer value: " + entry.getValue());
                    continue;
                }
                return new ItemStack(item, count, outputParseResult.getMeta());
            }
            catch (Exception e) {
                ModuleHunting.LOGGER.error("", (Throwable)e);
            }
        }
        return itemStack;
    }

    public float getCurrentProgress() {
        return 1.0f - this.currentProgress.get() / this.totalProgress.get();
    }

    public ItemStackHandler getInputStackHandler() {
        return this.inputStackHandler;
    }

    public ItemStack getNextItem() {
        ItemStack itemStack = this.inputStackHandler.getStackInSlot(0);
        if (itemStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStackHandler itemStackHandler = ItemBlockCarcass.getItemStackHandler(itemStack);
        if (itemStackHandler == null) {
            return ItemStack.field_190927_a;
        }
        int slot = this.getFirstNonEmptySlot(itemStackHandler);
        if (slot == -1) {
            return ItemStack.field_190927_a;
        }
        return itemStackHandler.getStackInSlot(slot);
    }

    private int getFirstNonEmptySlot(ItemStackHandler stackHandler) {
        for (int i = 0; i < stackHandler.getSlots(); ++i) {
            ItemStack stackInSlot = stackHandler.getStackInSlot(i);
            if (stackInSlot.func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inputStackHandler", (NBTBase)this.inputStackHandler.serializeNBT());
        return compound;
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inputStackHandler.deserializeNBT(compound.func_74775_l("inputStackHandler"));
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderBounds == null) {
            this.renderBounds = new AxisAlignedBB(this.func_174877_v()).func_72321_a(0.0, 0.5, 0.0);
        }
        return this.renderBounds;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    @Nullable
    public Stages getStages() {
        return ModuleHuntingConfig.STAGES_BUTCHERS_BLOCK;
    }

    public IInteraction<?>[] getInteractions() {
        return this.interactions;
    }

    private static class InputStackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        public InputStackHandler() {
            super(1);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack itemStack, boolean simulate) {
            if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemBlock && ((ItemBlock)itemStack.func_77973_b()).func_179223_d() == ModuleHunting.Blocks.CARCASS) {
                return super.insertItem(slot, itemStack, simulate);
            }
            return itemStack;
        }
    }

    public static class InputInteraction
    extends InteractionItemStack<TileButchersBlock> {
        public InputInteraction(ItemStackHandler stackHandler) {
            super(new ItemStackHandler[]{stackHandler}, 0, new EnumFacing[]{EnumFacing.UP}, InteractionBounds.BLOCK, new Transform(Transform.translate((double)0.5, (double)1.375, (double)0.5), Transform.rotate(), Transform.scale((double)0.75, (double)0.75, (double)0.75)));
        }

        protected boolean doItemStackValidation(ItemStack itemStack) {
            return !itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemBlock && ((ItemBlock)itemStack.func_77973_b()).func_179223_d() == ModuleHunting.Blocks.CARCASS;
        }
    }

    private static class InteractionInteractionCarcassDelegate
    implements InteractionCarcass.IInteractionCarcassDelegate {
        private final TileButchersBlock tile;

        public InteractionInteractionCarcassDelegate(TileButchersBlock tile) {
            this.tile = tile;
        }

        @Override
        public boolean canUseWithHungerLevel(int playerFoodLevel) {
            return !this.tile.inputStackHandler.getStackInSlot(0).func_190926_b() && playerFoodLevel < ModuleHuntingConfig.BUTCHERS_BLOCK.MINIMUM_HUNGER_TO_USE;
        }

        @Override
        public boolean canUseWithHeldItem(String registryName) {
            return !this.tile.inputStackHandler.getStackInSlot(0).func_190926_b() && (ArrayHelper.contains((Object[])ModuleHuntingConfig.BUTCHERS_BLOCK.ALLOWED_BUTCHERS_KNIVES, (Object)registryName) || ArrayHelper.contains((Object[])ModuleHuntingConfig.BUTCHERS_BLOCK.ALLOWED_HUNTERS_KNIVES, (Object)registryName));
        }

        @Override
        public void doExhaustion(EntityPlayer player) {
            if (ModuleHuntingConfig.BUTCHERS_BLOCK.EXHAUSTION_COST_PER_KNIFE_USE > 0.0) {
                player.func_71020_j((float)ModuleHuntingConfig.BUTCHERS_BLOCK.EXHAUSTION_COST_PER_KNIFE_USE);
            }
        }

        @Override
        public int getItemEfficiency(String registryName) {
            return ModuleHuntingConfig.BUTCHERS_BLOCK.KNIFE_EFFICIENCY.getOrDefault(registryName, 1);
        }

        @Override
        public void setCurrentProgress(float value) {
            this.tile.currentProgress.set(value);
        }

        @Override
        public float getCurrentProgress() {
            return this.tile.currentProgress.get();
        }

        @Override
        public ItemStack extractItem(ResourceLocation heldItemResourceLocation) {
            ItemStack itemStack = this.tile.inputStackHandler.getStackInSlot(0);
            ItemStackHandler itemStackHandler = ItemBlockCarcass.getItemStackHandler(itemStack);
            if (itemStackHandler == null) {
                return ItemStack.field_190927_a;
            }
            int slot = this.tile.getFirstNonEmptySlot(itemStackHandler);
            ItemStack result = itemStackHandler.extractItem(slot, 1, false);
            ItemBlockCarcass.updateItemStackHandler(itemStack, itemStackHandler);
            this.tile.inputStackHandler.setStackInSlot(0, itemStack);
            return this.tile.transformItem(heldItemResourceLocation, result);
        }

        @Override
        public BlockPos getPosition() {
            return this.tile.func_174877_v();
        }

        @Override
        public boolean isEmpty() {
            ItemStack itemStack = this.tile.inputStackHandler.getStackInSlot(0);
            if (itemStack.func_190926_b()) {
                return true;
            }
            ItemStackHandler itemStackHandler = ItemBlockCarcass.getItemStackHandler(itemStack);
            if (itemStackHandler == null) {
                return true;
            }
            return this.tile.getFirstNonEmptySlot(itemStackHandler) == -1;
        }

        @Override
        public void destroyCarcass() {
            this.tile.inputStackHandler.setStackInSlot(0, ItemStack.field_190927_a);
        }

        @Override
        public void resetProgress() {
            this.tile.resetProgress();
        }

        @Override
        public double getProgressParticleOffsetY() {
            return 1.5;
        }
    }
}

