/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.hunting.item.spi;

import com.codetaylor.mc.pyrotech.modules.hunting.entity.EntitySpear;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemSpearBase
extends Item {
    public ItemSpearBase() {
        this.func_77625_d(1);
        this.func_77656_e(this.getDurability());
        this.func_185043_a(new ResourceLocation("charging"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack itemStack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return entity != null && entity.func_184587_cr() && entity.func_184607_cu() == itemStack ? 1.0f : 0.0f;
            }
        });
    }

    protected abstract int getDurability();

    protected abstract double getVelocityScalar();

    protected abstract double getInaccuracy();

    protected abstract double getThrownDamage();

    public int func_77626_a(@Nonnull ItemStack itemStack) {
        return 72000;
    }

    @Nonnull
    public EnumAction func_77661_b(@Nonnull ItemStack itemStack) {
        return EnumAction.BOW;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }

    protected float getVelocity(int charge) {
        float velocity = (float)charge / 20.0f;
        if ((velocity = (velocity * velocity + velocity * 2.0f) / 3.0f) > 1.0f) {
            velocity = 1.0f;
        }
        return velocity;
    }

    @ParametersAreNonnullByDefault
    public void func_77615_a(ItemStack itemStack, World world, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            int i = this.func_77626_a(itemStack) - timeLeft;
            if (i < 0) {
                return;
            }
            float velocity = this.getVelocity(i);
            if ((double)velocity >= 0.1) {
                if (!world.field_72995_K) {
                    int k;
                    int j;
                    itemStack.func_77972_a(1, (EntityLivingBase)player);
                    EntitySpear entitySpear = new EntitySpear(world, (EntityLivingBase)player);
                    entitySpear.func_70239_b(this.getThrownDamage());
                    entitySpear.setItemStack(itemStack.func_77946_l());
                    entitySpear.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, (float)((double)velocity * this.getVelocityScalar()), (float)this.getInaccuracy());
                    if (velocity == 1.0f) {
                        entitySpear.func_70243_d(true);
                    }
                    if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)itemStack)) > 0) {
                        entitySpear.func_70239_b(entitySpear.func_70242_d() + (double)j * 0.5 + 0.5);
                    }
                    if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)itemStack)) > 0) {
                        entitySpear.func_70240_a(k);
                    }
                    if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)itemStack) > 0) {
                        entitySpear.func_70015_d(100);
                    }
                    if (player.field_71075_bZ.field_75098_d) {
                        entitySpear.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                    }
                    world.func_72838_d((Entity)entitySpear);
                }
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + velocity * 0.5f);
                player.field_71071_by.func_184437_d(itemStack);
                player.func_71029_a(StatList.func_188057_b((Item)this));
            }
        }
    }
}

