/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.hunting.event;

import com.codetaylor.mc.athenaeum.parser.recipe.item.MalformedRecipeItemException;
import com.codetaylor.mc.athenaeum.parser.recipe.item.ParseResult;
import com.codetaylor.mc.athenaeum.parser.recipe.item.RecipeItemParser;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.modules.hunting.ModuleHunting;
import com.codetaylor.mc.pyrotech.modules.hunting.ModuleHuntingConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.items.ItemStackHandler;

public class EntityLivingDropsEventHandler {
    private static Map<ResourceLocation, List<DropData>> DROP_MAP;
    private static List<ResourceLocation> DROP_CAPTURE_LIST;

    public static void on(LivingDropsEvent event) {
        Object itemStack;
        EntityLivingBase entityLiving = event.getEntityLiving();
        if (entityLiving.field_70170_p.field_72995_K) {
            return;
        }
        if (DROP_MAP == null) {
            DROP_MAP = DropMapFactory.create();
        }
        if (DROP_CAPTURE_LIST == null) {
            DROP_CAPTURE_LIST = DropCaptureFactory.create();
        }
        List drops = event.getDrops();
        ArrayList<Object> capturedDrops = new ArrayList<Object>();
        Iterator iterator = drops.iterator();
        while (iterator.hasNext()) {
            EntityItem entityItem = (EntityItem)iterator.next();
            itemStack = entityItem.func_92059_d();
            Item item = itemStack.func_77973_b();
            if (ModuleHuntingConfig.DROPS.REMOVE_LEATHER_DROPS && item == Items.field_151116_aA) {
                iterator.remove();
                continue;
            }
            if (!DROP_CAPTURE_LIST.contains(item.getRegistryName())) continue;
            capturedDrops.add(itemStack);
            iterator.remove();
        }
        ResourceLocation resourceLocation = EntityList.func_191301_a((Entity)entityLiving);
        List<DropData> dropData = DROP_MAP.get(resourceLocation);
        if (dropData != null) {
            for (DropData data : dropData) {
                if (!(RandomHelper.random().nextFloat() <= data.chance)) continue;
                capturedDrops.add(new ItemStack(data.item, data.count, data.meta));
            }
        }
        if (entityLiving instanceof EntitySheep) {
            SheepDropFactory.create((EntitySheep)entityLiving, capturedDrops);
        }
        if (entityLiving instanceof EntityLlama) {
            LlamaDropFactory.create((EntityLlama)entityLiving, capturedDrops);
        }
        if (!capturedDrops.isEmpty()) {
            itemStack = CarcassFactory.create(capturedDrops);
            drops.add(new EntityItem(entityLiving.field_70170_p, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, (ItemStack)itemStack));
        }
    }

    private static class DropData {
        private final Item item;
        private final int meta;
        private final int count;
        private final float chance;

        private DropData(Item item, int meta, int count, float chance) {
            this.item = item;
            this.meta = meta;
            this.count = count;
            this.chance = chance;
        }
    }

    private static class CarcassFactory {
        private CarcassFactory() {
        }

        private static ItemStack create(List<ItemStack> itemStacks) {
            ItemStackHandler itemStackHandler = new ItemStackHandler(itemStacks.size());
            for (int i = 0; i < itemStacks.size(); ++i) {
                itemStackHandler.insertItem(i, itemStacks.get(i), false);
            }
            ItemStack itemStack = new ItemStack((Block)ModuleHunting.Blocks.CARCASS);
            NBTTagCompound tag = StackHelper.getTagSafe((ItemStack)itemStack);
            NBTTagCompound tileEntityTag = new NBTTagCompound();
            tag.func_74782_a("BlockEntityTag", (NBTBase)tileEntityTag);
            tileEntityTag.func_74782_a("stackHandler", (NBTBase)itemStackHandler.serializeNBT());
            return itemStack;
        }
    }

    private static class DropCaptureFactory {
        private DropCaptureFactory() {
        }

        private static List<ResourceLocation> create() {
            ArrayList<ResourceLocation> result = new ArrayList<ResourceLocation>(ModuleHuntingConfig.DROPS.DROP_CAPTURE_LIST.length);
            for (String key : ModuleHuntingConfig.DROPS.DROP_CAPTURE_LIST) {
                result.add(new ResourceLocation(key));
            }
            return result;
        }
    }

    private static class DropMapFactory {
        private DropMapFactory() {
        }

        private static Map<ResourceLocation, List<DropData>> create() {
            HashMap<ResourceLocation, List<DropData>> result = new HashMap<ResourceLocation, List<DropData>>();
            for (Map.Entry<String, String> entry : ModuleHuntingConfig.DROPS.DROP_MAP.entrySet()) {
                String[] split;
                String key = entry.getKey();
                ResourceLocation entityResourceLocation = new ResourceLocation(key);
                Class entityClass = EntityList.getClass((ResourceLocation)entityResourceLocation);
                if (entityClass == null) {
                    ModuleHunting.LOGGER.error("Unknown entity: " + entityResourceLocation);
                    continue;
                }
                String value = entry.getValue();
                for (String itemString : split = value.split("&")) {
                    DropData dropData = DropMapFactory.createDropData(itemString);
                    if (dropData == null) continue;
                    List list = result.computeIfAbsent(entityResourceLocation, resourceLocation -> new ArrayList());
                    list.add(dropData);
                }
            }
            return result;
        }

        @Nullable
        private static DropData createDropData(String value) {
            float chance;
            int count;
            ParseResult parseResult;
            String[] split = value.split(";");
            if (split.length != 3) {
                ModuleHunting.LOGGER.error("Invalid drop string: " + value);
                return null;
            }
            try {
                parseResult = RecipeItemParser.INSTANCE.parse(split[0]);
            }
            catch (MalformedRecipeItemException e) {
                ModuleHunting.LOGGER.error("Unable to parse item string: " + split[0]);
                return null;
            }
            ResourceLocation itemResourceLocation = new ResourceLocation(parseResult.getDomain(), parseResult.getPath());
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemResourceLocation);
            if (item == null) {
                ModuleHunting.LOGGER.error("Unable to find item: " + split[0]);
                return null;
            }
            try {
                count = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException e) {
                ModuleHunting.LOGGER.error("Invalid integer: " + split[1]);
                return null;
            }
            try {
                chance = Float.parseFloat(split[2]);
            }
            catch (NumberFormatException e) {
                ModuleHunting.LOGGER.error("Invalid float: " + split[2]);
                return null;
            }
            return new DropData(item, parseResult.getMeta(), count, chance);
        }
    }

    private static class SheepDropFactory {
        private SheepDropFactory() {
        }

        private static void create(EntitySheep entitySheep, List<ItemStack> result) {
            if ((double)RandomHelper.random().nextFloat() > ModuleHuntingConfig.DROPS.SHEEP_PELT_CHANCE) {
                return;
            }
            if (!entitySheep.func_70892_o()) {
                EnumDyeColor fleeceColor = entitySheep.func_175509_cj();
                switch (fleeceColor) {
                    case BLUE: {
                        result.add(new ItemStack((Item)ModuleHunting.Items.PELT_SHEEP_BLUE, ModuleHuntingConfig.DROPS.SHEEP_PELT_COUNT));
                        return;
                    }
                    case RED: {
                        result.add(new ItemStack((Item)ModuleHunting.Items.PELT_SHEEP_RED, ModuleHuntingConfig.DROPS.SHEEP_PELT_COUNT));
                        return;
                    }
                    case GRAY: {
                        result.add(new ItemStack((Item)ModuleHunting.Items.PELT_SHEEP_GRAY, ModuleHuntingConfig.DROPS.SHEEP_PELT_COUNT));
                        return;
                    }
                    case BLACK: {
                        result.add(new ItemStack((Item)ModuleHunting.Items.PELT_SHEEP_BLACK, ModuleHuntingConfig.DROPS.SHEEP_PELT_COUNT));
                        return;
                    }
                    case BROWN: {
                        result.add(new ItemStack((Item)ModuleHunting.Items.PELT_SHEEP_BROWN, ModuleHuntingConfig.DROPS.SHEEP_PELT_COUNT));
                        return;
                    }
                    case GREEN: {
                        result.add(new ItemStack((Item)ModuleHunting.Items.PELT_SHEEP_GREEN, ModuleHuntingConfig.DROPS.SHEEP_PELT_COUNT));
                        return;
                    }
                    case WHITE: {
                        result.add(new ItemStack((Item)ModuleHunting.Items.PELT_SHEEP_WHITE, ModuleHuntingConfig.DROPS.SHEEP_PELT_COUNT));
                        return;
                    }
                    case SILVER: {
                        result.add(new ItemStack((Item)ModuleHunting.Items.PELT_SHEEP_GRAY_LIGHT, ModuleHuntingConfig.DROPS.SHEEP_PELT_COUNT));
                        return;
                    }
                    case YELLOW: {
                        result.add(new ItemStack((Item)ModuleHunting.Items.PELT_SHEEP_YELLOW, ModuleHuntingConfig.DROPS.SHEEP_PELT_COUNT));
                        return;
                    }
                    case CYAN: {
                        result.add(new ItemStack((Item)ModuleHunting.Items.PELT_SHEEP_CYAN, ModuleHuntingConfig.DROPS.SHEEP_PELT_COUNT));
                        return;
                    }
                    case LIME: {
                        result.add(new ItemStack((Item)ModuleHunting.Items.PELT_SHEEP_LIME, ModuleHuntingConfig.DROPS.SHEEP_PELT_COUNT));
                        return;
                    }
                    case PINK: {
                        result.add(new ItemStack((Item)ModuleHunting.Items.PELT_SHEEP_PINK, ModuleHuntingConfig.DROPS.SHEEP_PELT_COUNT));
                        return;
                    }
                    case ORANGE: {
                        result.add(new ItemStack((Item)ModuleHunting.Items.PELT_SHEEP_ORANGE, ModuleHuntingConfig.DROPS.SHEEP_PELT_COUNT));
                        return;
                    }
                    case PURPLE: {
                        result.add(new ItemStack((Item)ModuleHunting.Items.PELT_SHEEP_PURPLE, ModuleHuntingConfig.DROPS.SHEEP_PELT_COUNT));
                        return;
                    }
                    case MAGENTA: {
                        result.add(new ItemStack((Item)ModuleHunting.Items.PELT_SHEEP_MAGENTA, ModuleHuntingConfig.DROPS.SHEEP_PELT_COUNT));
                        return;
                    }
                    case LIGHT_BLUE: {
                        result.add(new ItemStack((Item)ModuleHunting.Items.PELT_SHEEP_BLUE_LIGHT, ModuleHuntingConfig.DROPS.SHEEP_PELT_COUNT));
                        return;
                    }
                }
                throw new IllegalStateException("Unknown enum: " + fleeceColor);
            }
            result.add(new ItemStack((Item)ModuleHunting.Items.HIDE_SHEEP_SHEARED, ModuleHuntingConfig.DROPS.SHEEP_PELT_COUNT));
        }
    }

    private static class LlamaDropFactory {
        private LlamaDropFactory() {
        }

        private static void create(EntityLlama entityLlama, List<ItemStack> result) {
            if ((double)RandomHelper.random().nextFloat() > ModuleHuntingConfig.DROPS.LLAMA_PELT_CHANCE) {
                return;
            }
            int variant = entityLlama.func_190719_dM();
            switch (variant) {
                case 0: {
                    result.add(new ItemStack((Item)ModuleHunting.Items.PELT_LLAMA_CREAMY, ModuleHuntingConfig.DROPS.LLAMA_PELT_COUNT));
                    return;
                }
                case 1: {
                    result.add(new ItemStack((Item)ModuleHunting.Items.PELT_LLAMA_WHITE, ModuleHuntingConfig.DROPS.LLAMA_PELT_COUNT));
                    return;
                }
                case 2: {
                    result.add(new ItemStack((Item)ModuleHunting.Items.PELT_LLAMA_BROWN, ModuleHuntingConfig.DROPS.LLAMA_PELT_COUNT));
                    return;
                }
                case 3: {
                    result.add(new ItemStack((Item)ModuleHunting.Items.PELT_LLAMA_GRAY, ModuleHuntingConfig.DROPS.LLAMA_PELT_COUNT));
                    return;
                }
            }
            throw new RuntimeException("Unknown llama variant: " + variant);
        }
    }
}

