/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.core.recipe;

import com.codetaylor.mc.athenaeum.util.OreDictHelper;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.pyrotech.modules.hunting.ModuleHunting;
import com.codetaylor.mc.pyrotech.modules.hunting.ModuleHuntingConfig;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class LeatherRepairRecipe
extends ShapelessOreRecipe {
    private final double repairPercentage;

    public LeatherRepairRecipe(ResourceLocation group, NonNullList<Ingredient> input, @Nonnull ItemStack result, double repairPercentage) {
        super(group, input, result);
        this.repairPercentage = repairPercentage;
        this.isSimple = false;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inventoryCrafting) {
        int size = inventoryCrafting.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            ItemStack itemStack = inventoryCrafting.func_70301_a(i);
            if (itemStack.func_77973_b() != Items.field_151024_Q && itemStack.func_77973_b() != Items.field_151027_R && itemStack.func_77973_b() != Items.field_151026_S && itemStack.func_77973_b() != Items.field_151021_T) continue;
            if (itemStack.func_77952_i() == 0) {
                return ItemStack.field_190927_a;
            }
            ItemStack copy = itemStack.func_77946_l();
            copy.func_77964_b(Math.max(0, copy.func_77952_i() - (int)((double)copy.func_77958_k() * this.repairPercentage)));
            return copy;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList result = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < result.size(); ++i) {
            ItemStack itemStack = inv.func_70301_a(i);
            if (OreDictHelper.contains((String)"toolHuntersKnife", (ItemStack)itemStack)) {
                if ((itemStack = itemStack.func_77946_l()).func_96631_a(ModuleHuntingConfig.LEATHER_KITS.HUNTERS_KNIFE_REPAIR_DAMAGE, RandomHelper.random(), null)) {
                    itemStack.func_190918_g(1);
                }
                result.set(i, (Object)itemStack);
                continue;
            }
            if (itemStack.func_77973_b() == ModuleHunting.Items.LEATHER_REPAIR_KIT || itemStack.func_77973_b() == ModuleHunting.Items.LEATHER_DURABLE_REPAIR_KIT) {
                if ((itemStack = itemStack.func_77946_l()).func_96631_a(1, RandomHelper.random(), null)) {
                    itemStack.func_190918_g(1);
                }
                result.set(i, (Object)itemStack);
                continue;
            }
            ItemStack containerItem = ForgeHooks.getContainerItem((ItemStack)itemStack);
            result.set(i, (Object)containerItem);
        }
        return result;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList ingredients = NonNullList.func_191196_a();
            for (JsonElement ele : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
                ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)ele, (JsonContext)context));
            }
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            ItemStack itemstack = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
            return new LeatherRepairRecipe(group.isEmpty() ? null : new ResourceLocation(group), (NonNullList<Ingredient>)ingredients, itemstack, ModuleHuntingConfig.LEATHER_KITS.PERCENTAGE_DURABILITY_REPAIRED);
        }
    }
}

