/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.core.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class LeatherArmorDurableUpgradeRecipe
extends ShapelessOreRecipe {
    private LeatherArmorDurableUpgradeRecipe(ResourceLocation group, NonNullList<Ingredient> input, @Nonnull ItemStack result) {
        super(group, input, result);
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inventoryCrafting) {
        int size = inventoryCrafting.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            ItemStack itemStack = inventoryCrafting.func_70301_a(i);
            if (itemStack.func_77973_b() != Items.field_151024_Q && itemStack.func_77973_b() != Items.field_151027_R && itemStack.func_77973_b() != Items.field_151026_S && itemStack.func_77973_b() != Items.field_151021_T) continue;
            ItemStack newItemStack = this.applyUnbreakingEnchantment(itemStack);
            if (!newItemStack.func_190926_b()) {
                NBTTagCompound displayTag = newItemStack.func_190925_c("display");
                displayTag.func_74768_a("color", 4791302);
            }
            return newItemStack;
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack applyUnbreakingEnchantment(ItemStack itemStack) {
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
        for (Enchantment enchantment : enchantments.keySet()) {
            if (enchantment == Enchantments.field_185307_s) {
                return ItemStack.field_190927_a;
            }
            if (com.codetaylor.mc.athenaeum.util.EnchantmentHelper.isCompatible((Enchantment)Enchantments.field_185307_s, (Enchantment)enchantment)) continue;
            return ItemStack.field_190927_a;
        }
        ItemStack copy = itemStack.func_77946_l();
        enchantments.put(Enchantments.field_185307_s, 1);
        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)copy);
        return copy;
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inventoryCrafting, @Nonnull World world) {
        if (this.func_77572_b(inventoryCrafting) == ItemStack.field_190927_a) {
            return false;
        }
        return super.func_77569_a(inventoryCrafting, world);
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList ingredients = NonNullList.func_191196_a();
            for (JsonElement ele : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
                ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)ele, (JsonContext)context));
            }
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            ItemStack itemstack = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
            return new LeatherArmorDurableUpgradeRecipe(group.isEmpty() ? null : new ResourceLocation(group), ingredients, itemstack);
        }
    }
}

