/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.core.network;

import com.codetaylor.mc.pyrotech.library.particle.ParticleEmitter;
import com.codetaylor.mc.pyrotech.library.particle.ParticleFactoryAdapter;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDrip;
import net.minecraft.client.particle.ParticleSplash;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SCPacketParticleDrip
implements IMessage,
IMessageHandler<SCPacketParticleDrip, IMessage> {
    private double x;
    private double y;
    private double z;
    private double rangeX;
    private double rangeY;
    private double rangeZ;

    public SCPacketParticleDrip() {
    }

    public SCPacketParticleDrip(double x, double y, double z, double rangeX, double rangeY, double rangeZ) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.rangeX = rangeX;
        this.rangeY = rangeY;
        this.rangeZ = rangeZ;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.rangeX);
        buf.writeDouble(this.rangeY);
        buf.writeDouble(this.rangeZ);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.rangeX = buf.readDouble();
        this.rangeY = buf.readDouble();
        this.rangeZ = buf.readDouble();
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(SCPacketParticleDrip message, MessageContext ctx) {
        if (ModuleCoreConfig.CLIENT.SHOW_RECIPE_PROGRESSION_PARTICLES) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            ParticleEmitter particleEmitter = new ParticleEmitter((World)world, new Vec3d(message.x, message.y, message.z), new Vec3d(message.rangeX, message.rangeY, message.rangeZ), 2, 30, new ParticleFactoryAdapter(new CustomParticleDrip.Factory()));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particleEmitter);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static class CustomParticleSplash
    extends ParticleSplash {
        public CustomParticleSplash(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn) {
            super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
            this.field_70544_f = 0.75f;
        }

        public void func_189213_a() {
            this.field_187123_c = this.field_187126_f;
            this.field_187124_d = this.field_187127_g;
            this.field_187125_e = this.field_187128_h;
            this.field_187130_j -= (double)this.field_70545_g;
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            this.field_187129_i *= (double)0.98f;
            this.field_187130_j *= (double)0.98f;
            this.field_187131_k *= (double)0.98f;
            if (this.field_187132_l) {
                if (Math.random() < 0.5) {
                    this.func_187112_i();
                }
                this.field_187129_i *= (double)0.7f;
                this.field_187131_k *= (double)0.7f;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class CustomParticleDrip
    extends ParticleDrip {
        protected CustomParticleDrip(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, Material p_i1203_8_) {
            super(worldIn, xCoordIn, yCoordIn, zCoordIn, p_i1203_8_);
            this.field_70547_e = 30;
            this.field_70544_f = (this.field_187136_p.nextFloat() * 0.5f + 0.5f) * 1.5f;
            this.field_187130_j = 0.0;
        }

        public void func_189213_a() {
            this.field_187123_c = this.field_187126_f;
            this.field_187124_d = this.field_187127_g;
            this.field_187125_e = this.field_187128_h;
            this.field_70552_h = 0.2f;
            this.field_70553_i = 0.3f;
            this.field_70551_j = 1.0f;
            this.field_187130_j -= ((double)((float)this.field_70546_d / (float)this.field_70547_e) * 0.9 + 0.1) * (double)this.field_70545_g * 0.5;
            this.func_70536_a(112);
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            this.field_187129_i *= (double)0.98f;
            this.field_187130_j *= (double)0.98f;
            this.field_187131_k *= (double)0.98f;
            if (this.field_187132_l || this.field_70546_d++ >= this.field_70547_e) {
                this.func_187112_i();
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new CustomParticleSplash(this.field_187122_b, this.field_187126_f, this.field_187127_g, this.field_187128_h, 0.0, 0.0, 0.0));
                this.field_187129_i *= (double)0.7f;
                this.field_187131_k *= (double)0.7f;
            }
        }

        @SideOnly(value=Side.CLIENT)
        public static class Factory
        implements IParticleFactory {
            public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... p_178902_15_) {
                return new CustomParticleDrip(worldIn, xCoordIn, yCoordIn, zCoordIn, Material.field_151586_h);
            }
        }
    }
}

