/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.core.event;

import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import com.codetaylor.mc.pyrotech.modules.core.block.BlockStrawBed;
import com.codetaylor.mc.pyrotech.modules.core.event.PlayerSleepInStrawBedEvent;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class StrawBedEventHandler {
    private final Int2ObjectMap<List<BlockPos>> usedBeds = new Int2ObjectOpenHashMap();

    public StrawBedEventHandler() {
        this.usedBeds.defaultReturnValue(null);
    }

    @SubscribeEvent
    public void on(TickEvent.WorldTickEvent event) {
        block8: {
            List blockPosList;
            World world;
            block7: {
                if (event.phase != TickEvent.Phase.END) {
                    return;
                }
                world = event.world;
                if (world.field_72995_K) {
                    return;
                }
                int dimensionId = world.field_73011_w.getDimension();
                blockPosList = (List)this.usedBeds.get(dimensionId);
                if (blockPosList == null || blockPosList.isEmpty()) {
                    return;
                }
                if (!ModuleCoreConfig.STRAW_BED.DAYTIME_DESTROY_CHECK || !world.func_72935_r()) break block7;
                for (int i = blockPosList.size() - 1; i >= 0; --i) {
                    BlockPos blockPos = (BlockPos)blockPosList.get(i);
                    IBlockState blockState = world.func_180495_p(blockPos);
                    Block block = blockState.func_177230_c();
                    if (block == ModuleCore.Blocks.STRAW_BED) {
                        world.func_175655_b(blockPos, false);
                    }
                    blockPosList.remove(i);
                }
                break block8;
            }
            if (ModuleCoreConfig.STRAW_BED.DAYTIME_DESTROY_CHECK) break block8;
            for (int i = blockPosList.size() - 1; i >= 0; --i) {
                BlockPos blockPos = (BlockPos)blockPosList.get(i);
                IBlockState blockState = world.func_180495_p(blockPos);
                Block block = blockState.func_177230_c();
                if (block != ModuleCore.Blocks.STRAW_BED) {
                    world.func_175655_b(blockPos, false);
                    continue;
                }
                if (((BlockStrawBed)block).isOccupied(world, blockPos)) continue;
                world.func_175655_b(blockPos, false);
                blockPosList.remove(i);
            }
        }
    }

    @SubscribeEvent
    public void on(PlayerSetSpawnEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        BlockPos bedLocation = player.field_71081_bT;
        if (bedLocation == null) {
            return;
        }
        IBlockState blockState = world.func_180495_p(bedLocation);
        Block block = blockState.func_177230_c();
        if (block == ModuleCore.Blocks.STRAW_BED) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void on(PlayerSleepInStrawBedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        BlockPos bedLocation = player.field_71081_bT;
        if (bedLocation == null) {
            return;
        }
        IBlockState blockState = world.func_180495_p(bedLocation);
        Block block = blockState.func_177230_c();
        if (block == ModuleCore.Blocks.STRAW_BED) {
            this.addUsedBed(world, bedLocation);
        }
    }

    private void addUsedBed(World world, BlockPos pos) {
        int dimensionId = world.field_73011_w.getDimension();
        ArrayList<BlockPos> blockPosList = (ArrayList<BlockPos>)this.usedBeds.get(dimensionId);
        if (blockPosList == null) {
            blockPosList = new ArrayList<BlockPos>();
            this.usedBeds.put(dimensionId, blockPosList);
        }
        blockPosList.add(pos);
    }
}

