/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.core.event;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="pyrotech")
public final class PlayerMovementTracker {
    private static final Object2IntMap<UUID> TICKS_SINCE_LAST_MOVE = new Object2IntArrayMap();
    private static final Map<UUID, BlockPos> LAST_KNOWN_POSITION;

    @SubscribeEvent
    public static void on(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K || event.phase != TickEvent.Phase.START) {
            return;
        }
        UUID uuid = event.player.func_110124_au();
        BlockPos lastPos = LAST_KNOWN_POSITION.get(uuid);
        BlockPos position = event.player.func_180425_c();
        if (position.equals((Object)lastPos)) {
            TICKS_SINCE_LAST_MOVE.put((Object)uuid, TICKS_SINCE_LAST_MOVE.getInt((Object)uuid) + 1);
        } else {
            TICKS_SINCE_LAST_MOVE.put((Object)uuid, 0);
        }
        LAST_KNOWN_POSITION.put(uuid, position);
    }

    public static int getTicksSinceLastMove(EntityPlayer player) {
        return (Integer)TICKS_SINCE_LAST_MOVE.get((Object)player.func_110124_au());
    }

    static {
        TICKS_SINCE_LAST_MOVE.defaultReturnValue(0);
        LAST_KNOWN_POSITION = new HashMap<UUID, BlockPos>();
    }
}

