/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.core.block.spi;

import com.codetaylor.mc.athenaeum.spi.BlockPartialBase;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.item.ItemMaterial;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockOreDenseRedstoneBase
extends BlockPartialBase {
    private static final int TICK_RATE = 30;
    protected final boolean activated;

    public BlockOreDenseRedstoneBase(boolean activated) {
        super(Material.field_151576_e);
        this.activated = activated;
        this.func_149752_b(5.0f);
        this.func_149711_c(3.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149675_a(this.activated);
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        this.activate(world, pos);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        this.activate(world, pos);
    }

    public void activate(World world, BlockPos pos) {
        this.spawnParticles(world, pos, this.getParticleCount());
        if (!this.activated) {
            world.func_175656_a(pos, this.getActiveState());
            this.playSound(world, pos);
        } else if ((double)world.field_73012_v.nextFloat() < 0.25) {
            this.playSound(world, pos);
        }
    }

    public void playSound(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            SoundEvent[] soundEvents = new SoundEvent[]{ModuleCore.Sounds.DENSE_REDSTONE_ORE_ACTIVATE_00, ModuleCore.Sounds.DENSE_REDSTONE_ORE_ACTIVATE_01, ModuleCore.Sounds.DENSE_REDSTONE_ORE_ACTIVATE_02, ModuleCore.Sounds.DENSE_REDSTONE_ORE_ACTIVATE_03, ModuleCore.Sounds.DENSE_REDSTONE_ORE_ACTIVATE_04, ModuleCore.Sounds.DENSE_REDSTONE_ORE_ACTIVATE_05, ModuleCore.Sounds.DENSE_REDSTONE_ORE_ACTIVATE_06, ModuleCore.Sounds.DENSE_REDSTONE_ORE_ACTIVATE_07};
            world.func_184133_a(null, pos, soundEvents[world.field_73012_v.nextInt(soundEvents.length)], SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public boolean isActivated() {
        return this.activated;
    }

    @ParametersAreNonnullByDefault
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.activated) {
            this.spawnParticles(world, pos, this.getParticleCount());
        }
    }

    @ParametersAreNonnullByDefault
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.activated) {
            world.func_175656_a(pos, this.getInactiveState());
        }
    }

    @ParametersAreNonnullByDefault
    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int count = this.func_149679_a(fortune, rand);
        for (int i = 0; i < count; ++i) {
            if ((double)rand.nextFloat() < 0.25) {
                drops.add((Object)new ItemStack(Items.field_151137_ax));
                continue;
            }
            drops.add((Object)ItemMaterial.EnumType.DENSE_REDSTONE.asStack());
        }
    }

    public CreativeTabs func_149708_J() {
        return this.activated ? super.func_149708_J() : null;
    }

    public int func_149738_a(@Nonnull World world) {
        return 30;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return super.func_176198_a(world, pos, side) && world.isSideSolid(pos.func_177977_b(), EnumFacing.UP);
    }

    @ParametersAreNonnullByDefault
    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        this.activate(world, pos);
        super.func_180649_a(world, pos, player);
    }

    @ParametersAreNonnullByDefault
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        this.activate(world, pos);
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public int func_149679_a(int fortune, @Nonnull Random random) {
        return this.func_149745_a(random) + random.nextInt(fortune + 1);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.activated ? this.getActiveLightValue() : super.getLightValue(state, world, pos);
    }

    protected abstract IBlockState getInactiveState();

    protected abstract IBlockState getActiveState();

    protected abstract int getActiveLightValue();

    protected abstract int getParticleCount();

    public abstract int getProximityRepairAmount();

    protected void spawnParticles(World world, BlockPos pos, int particleCount) {
        Random random = world.field_73012_v;
        for (int i = 0; i < particleCount; ++i) {
            double d1 = (float)pos.func_177958_n() + random.nextFloat();
            double d2 = (float)pos.func_177956_o() + random.nextFloat();
            double d3 = (float)pos.func_177952_p() + random.nextFloat();
            if (i == 0 && !world.func_180495_p(pos.func_177984_a()).func_185914_p()) {
                d2 = (double)pos.func_177956_o() + 0.0625 + 1.0;
            }
            if (i == 1 && !world.func_180495_p(pos.func_177977_b()).func_185914_p()) {
                d2 = (double)pos.func_177956_o() - 0.0625;
            }
            if (i == 2 && !world.func_180495_p(pos.func_177968_d()).func_185914_p()) {
                d3 = (double)pos.func_177952_p() + 0.0625 + 1.0;
            }
            if (i == 3 && !world.func_180495_p(pos.func_177978_c()).func_185914_p()) {
                d3 = (double)pos.func_177952_p() - 0.0625;
            }
            if (i == 4 && !world.func_180495_p(pos.func_177974_f()).func_185914_p()) {
                d1 = (double)pos.func_177958_n() + 0.0625 + 1.0;
            }
            if (i == 5 && !world.func_180495_p(pos.func_177976_e()).func_185914_p()) {
                d1 = (double)pos.func_177958_n() - 0.0625;
            }
            if (!(d1 < (double)pos.func_177958_n() || d1 > (double)(pos.func_177958_n() + 1) || d2 < 0.0 || d2 > (double)(pos.func_177956_o() + 1) || d3 < (double)pos.func_177952_p()) && !(d3 > (double)(pos.func_177952_p() + 1))) continue;
            world.func_175688_a(EnumParticleTypes.REDSTONE, d1, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

