/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.core.block.spi;

import com.codetaylor.mc.athenaeum.spi.BlockPartialBase;
import com.codetaylor.mc.athenaeum.util.AABBHelper;
import com.codetaylor.mc.athenaeum.util.Properties;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockBushBase
extends BlockPartialBase {
    private static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    private static final Random RANDOM = new Random();
    private static final AxisAlignedBB[] AABB = new AxisAlignedBB[]{AABBHelper.create((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)3.0, (double)9.0), AABBHelper.create((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)6.0, (double)9.0), AABBHelper.create((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0), AABBHelper.create((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0), AABBHelper.create((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), AABBHelper.create((double)3.0, (double)5.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0), AABBHelper.create((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), AABBHelper.create((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0)};
    private static final List<Int2ObjectMap<AxisAlignedBB>> OFFSET_AABB = new ArrayList<Int2ObjectMap<AxisAlignedBB>>(8);

    private static int encodeOffset(int x, int z) {
        return x & 3 | (z & 3) << 2;
    }

    public BlockBushBase() {
        super(Material.field_151575_d);
        this.func_149675_a(true);
        this.func_149711_c(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    public abstract boolean isValidBlock(IBlockState var1);

    public abstract Item getSeedItem();

    public int getMaxAge() {
        return 7;
    }

    public int getAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public IBlockState withAge(int age) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE) >= this.getMaxAge();
    }

    @ParametersAreNonnullByDefault
    public float func_176195_g(IBlockState blockState, World world, BlockPos pos) {
        if (this.getAge(blockState) < 3) {
            return 0.1f;
        }
        return super.func_176195_g(blockState, world, pos);
    }

    @ParametersAreNonnullByDefault
    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState blockState, EntityPlayer player) {
        return false;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public Vec3d func_190949_e(IBlockState state, IBlockAccess world, BlockPos pos) {
        long seed = MathHelper.func_180187_c((int)pos.func_177958_n(), (int)0, (int)pos.func_177952_p());
        int value = (int)(seed >> 16 & 0xFL);
        int x = (value & 3) % 3;
        int z = (value >> 2 & 3) % 3;
        return new Vec3d((double)(x - 1) * 0.0625, 0.0, (double)(z - 1) * 0.0625);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public SoundType getSoundType(IBlockState blockState, World world, BlockPos pos, @Nullable Entity entity) {
        switch (this.getAge(blockState)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return SoundType.field_185850_c;
            }
        }
        return SoundType.field_185848_a;
    }

    @Nonnull
    public Material func_149688_o(@Nonnull IBlockState blockState) {
        switch (this.getAge(blockState)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return Material.field_151585_k;
            }
        }
        return Material.field_151575_d;
    }

    @Nonnull
    public EnumPushReaction func_149656_h(@Nonnull IBlockState blockState) {
        switch (this.getAge(blockState)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return EnumPushReaction.DESTROY;
            }
        }
        return EnumPushReaction.BLOCK;
    }

    public boolean func_176200_f(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return (Integer)world.func_180495_p(pos).func_177229_b((IProperty)AGE) < 4;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        int age = (Integer)blockState.func_177229_b((IProperty)AGE);
        if (age < 0 || age >= AABB.length) {
            return super.func_185496_a(blockState, world, pos);
        }
        long seed = MathHelper.func_180187_c((int)pos.func_177958_n(), (int)0, (int)pos.func_177952_p());
        int value = (int)(seed >> 16 & 0xFL);
        int x = (value & 3) % 3;
        int z = (value >> 2 & 3) % 3;
        int encodedOffset = BlockBushBase.encodeOffset(x, z);
        return (AxisAlignedBB)OFFSET_AABB.get(age).get(encodedOffset);
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        switch (this.getAge(blockState)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return Block.field_185506_k;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return this.func_185496_a(blockState, world, pos);
            }
        }
        return super.func_180646_a(blockState, world, pos);
    }

    @ParametersAreNonnullByDefault
    public void func_189540_a(IBlockState blockState, World world, BlockPos pos, Block block, BlockPos fromPos) {
        this.checkAndDropBlock(world, pos);
    }

    protected void checkAndDropBlock(World world, BlockPos pos) {
        if (!this.isValidBlock(world.func_180495_p(pos.func_177977_b()))) {
            world.func_175655_b(pos, true);
        }
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public Item func_180660_a(IBlockState blockState, Random rand, int fortune) {
        if (this.getAge(blockState) < 3) {
            return this.getSeedItem();
        }
        return Items.field_151055_y;
    }

    @ParametersAreNonnullByDefault
    public int quantityDropped(IBlockState blockState, int fortune, Random random) {
        if (this.getAge(blockState) < 3) {
            return 1;
        }
        return random.nextInt(3) + 1;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.withAge(meta);
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return this.getAge(state);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, Properties.FACING_HORIZONTAL});
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public IBlockState func_176221_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        RANDOM.setSeed(MathHelper.func_180187_c((int)pos.func_177958_n(), (int)0, (int)pos.func_177952_p()));
        EnumFacing facing = EnumFacing.field_176754_o[RANDOM.nextInt(4)];
        return blockState.func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)facing);
    }

    static {
        for (AxisAlignedBB axisAlignedBB : AABB) {
            Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap(9);
            OFFSET_AABB.add((Int2ObjectMap<AxisAlignedBB>)map);
            for (int x = 0; x < 3; ++x) {
                for (int z = 0; z < 3; ++z) {
                    map.put(BlockBushBase.encodeOffset(x, z), (Object)axisAlignedBB.func_72317_d((double)(x - 1) * 0.0625, 0.0, (double)(z - 1) * 0.0625));
                }
            }
        }
    }
}

