/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.core.block;

import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.library.spi.block.IBlockShearable;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import com.codetaylor.mc.pyrotech.modules.core.block.spi.BlockBushBase;
import com.codetaylor.mc.pyrotech.modules.core.network.SCPacketParticleCombust;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BlockPyroberryBush
extends BlockBushBase
implements IBlockShearable {
    public static final String NAME = "pyroberry_bush";

    @Override
    public boolean isValidBlock(IBlockState blockState) {
        return blockState.func_185904_a() == Material.field_151595_p;
    }

    @Override
    public Item getSeedItem() {
        return ModuleCore.Items.PYROBERRY_SEEDS;
    }

    @ParametersAreNonnullByDefault
    public void func_180663_b(World world, BlockPos pos, IBlockState blockState) {
        super.func_180663_b(world, pos, blockState);
        if (!world.field_72995_K) {
            switch (this.getAge(blockState)) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    this.spawnFireParticles(pos, world.field_73011_w.getDimension());
                    world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            }
        }
        if (this.isMaxAge(blockState)) {
            world.func_72876_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 1.5f, true);
        }
    }

    @ParametersAreNonnullByDefault
    public boolean func_180639_a(World world, BlockPos pos, IBlockState blockState, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND) {
            ItemStack itemStack = player.func_184614_ca();
            Item item = itemStack.func_77973_b();
            if (item == Items.field_151065_br) {
                int age = this.getAge(blockState);
                if (age < this.getMaxAge() && ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)blockState, (boolean)true)) {
                    if (!player.func_184812_l_() && !player.func_175149_v()) {
                        itemStack.func_190920_e(itemStack.func_190916_E() - 1);
                    }
                    world.func_180501_a(pos, this.withAge(age + 1), 2);
                    world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    this.spawnFireParticles(pos, world.field_73011_w.getDimension());
                    ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)blockState, (IBlockState)world.func_180495_p(pos));
                } else if (this.isMaxAge(blockState)) {
                    this.spawnFireParticles(pos, world.field_73011_w.getDimension());
                    world.func_72876_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 1.5f, true);
                }
                return true;
            }
            if (item == Items.field_190931_a && this.isMaxAge(blockState)) {
                this.spawnFireParticles(pos, world.field_73011_w.getDimension());
                world.func_72876_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 1.5f, true);
                return true;
            }
        }
        return super.func_180639_a(world, pos, blockState, player, hand, facing, hitX, hitY, hitZ);
    }

    @ParametersAreNonnullByDefault
    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        super.func_180649_a(world, pos, player);
        if (this.getAge(world.func_180495_p(pos)) == this.getMaxAge()) {
            this.spawnFireParticles(pos, world.field_73011_w.getDimension());
        }
    }

    @ParametersAreNonnullByDefault
    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        super.func_176199_a(world, pos, entity);
        if ((double)RandomHelper.random().nextFloat() < 0.05 && this.getAge(world.func_180495_p(pos)) == this.getMaxAge()) {
            this.spawnFireParticles(pos, world.field_73011_w.getDimension());
        }
    }

    @Override
    public void onSheared(World world, BlockPos pos, IBlockState blockState, ItemStack itemStack, EntityPlayer player) {
        if (this.isMaxAge(blockState)) {
            world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 1.0f);
            world.func_180501_a(pos, this.withAge(this.getMaxAge() - 1), 3);
            itemStack.func_77972_a(1, (EntityLivingBase)player);
            this.spawnFireParticles(pos, player.field_71093_bK);
            world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f, 1.0f);
            StackHelper.spawnStackOnTop((World)world, (ItemStack)new ItemStack((Item)ModuleCore.Items.PYROBERRIES, RandomHelper.random().nextInt(3) + 1), (BlockPos)pos, (double)0.5);
        }
    }

    private void spawnFireParticles(BlockPos pos, int dimension) {
        ModuleCore.PACKET_SERVICE.sendToAllAround((IMessage)new SCPacketParticleCombust((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.5, 0.5, 0.5), dimension, pos);
    }

    @ParametersAreNonnullByDefault
    public void func_180650_b(World world, BlockPos pos, IBlockState blockState, Random rand) {
        this.checkAndDropBlock(world, pos);
        if (world.func_175678_i(pos)) {
            if (world.func_175727_C(pos.func_177984_a())) {
                int age = this.getAge(blockState);
                if (age > 4 && ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)blockState, ((double)rand.nextFloat() < ModuleCoreConfig.PYROBERRY_BUSH.RAIN_GROWTH_REVERT_CHANCE ? 1 : 0) != 0)) {
                    world.func_180501_a(pos, this.withAge(age - 1), 2);
                    ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)blockState, (IBlockState)world.func_180495_p(pos));
                }
                if (!world.field_72995_K) {
                    for (int i = 0; i < 8; ++i) {
                        double offsetX = (RandomHelper.random().nextDouble() * 2.0 - 1.0) * 0.4;
                        double offsetY = (RandomHelper.random().nextDouble() * 2.0 - 1.0) * 0.4;
                        double offsetZ = (RandomHelper.random().nextDouble() * 2.0 - 1.0) * 0.4;
                        double x = (double)pos.func_177958_n() + 0.5 + offsetX;
                        double y = (double)pos.func_177956_o() + 0.6 + offsetY;
                        double z = (double)pos.func_177952_p() + 0.5 + offsetZ;
                        ((WorldServer)world).func_175739_a((double)RandomHelper.random().nextFloat() < 0.25 ? EnumParticleTypes.SMOKE_LARGE : EnumParticleTypes.SMOKE_NORMAL, x, y, z, 4, 0.0, 0.0, 0.0, 0.0, new int[0]);
                    }
                    world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 1.0f);
                }
            } else if (world.func_72935_r()) {
                int age = this.getAge(blockState);
                boolean grew = false;
                if (age < this.getMaxAge()) {
                    double chance = age == this.getMaxAge() - 1 ? ModuleCoreConfig.PYROBERRY_BUSH.BERRY_GROWTH_CHANCE : ModuleCoreConfig.PYROBERRY_BUSH.GROWTH_CHANCE;
                    if (ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)blockState, ((double)rand.nextFloat() < chance ? 1 : 0) != 0)) {
                        world.func_180501_a(pos, this.withAge(age + 1), 2);
                        grew = true;
                        ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)blockState, (IBlockState)world.func_180495_p(pos));
                    }
                }
                if (age > 2 && grew || this.isMaxAge(blockState) && (double)rand.nextFloat() < 0.5) {
                    this.spawnFireParticles(pos, world.field_73011_w.getDimension());
                    world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            }
        } else {
            int age = this.getAge(blockState);
            if (age > 4 && ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)blockState, ((double)rand.nextFloat() < ModuleCoreConfig.PYROBERRY_BUSH.OBSTRUCTED_GROWTH_REVERT_CHANCE ? 1 : 0) != 0)) {
                world.func_180501_a(pos, this.withAge(age - 1), 2);
                ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)blockState, (IBlockState)world.func_180495_p(pos));
            }
        }
    }
}

