/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.library.spi.plugin.jei;

import com.codetaylor.mc.pyrotech.library.spi.plugin.jei.IPyrotechRecipeWrapper;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.startup.ForgeModIdHelper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public abstract class PyrotechRecipeCategory<T extends IPyrotechRecipeWrapper>
implements IRecipeCategory<T> {
    @ParametersAreNonnullByDefault
    public void setRecipe(IRecipeLayout recipeLayout, T recipeWrapper, IIngredients ingredients) {
        ResourceLocation registryName = recipeWrapper.getRegistryName();
        if (registryName != null) {
            IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
            guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                if (slotIndex == this.getOutputSlotIndex()) {
                    boolean showAdvanced;
                    String modName;
                    String recipeModId = registryName.func_110624_b();
                    boolean modIdDifferent = false;
                    ResourceLocation itemRegistryName = ingredient.func_77973_b().getRegistryName();
                    if (itemRegistryName != null) {
                        String itemModId = itemRegistryName.func_110624_b();
                        boolean bl = modIdDifferent = !recipeModId.equals(itemModId);
                    }
                    if (modIdDifferent && (modName = ForgeModIdHelper.getInstance().getFormattedModNameForModId(recipeModId)) != null) {
                        tooltip.add(TextFormatting.GRAY + Translator.translateToLocalFormatted((String)"jei.tooltip.recipe.by", (Object[])new Object[]{modName}));
                    }
                    boolean bl = showAdvanced = Minecraft.func_71410_x().field_71474_y.field_82882_x || GuiScreen.func_146272_n();
                    if (showAdvanced) {
                        tooltip.add(TextFormatting.DARK_GRAY + Translator.translateToLocalFormatted((String)"jei.tooltip.recipe.id", (Object[])new Object[]{registryName.toString()}));
                    }
                }
            });
        }
    }

    protected abstract int getOutputSlotIndex();
}

