/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.library.patreon.data;

import com.codetaylor.mc.pyrotech.library.patreon.data.EffectDataBase;
import com.codetaylor.mc.pyrotech.library.patreon.data.EffectDataList;
import com.codetaylor.mc.pyrotech.library.patreon.data.IEffectDataJsonAdapter;
import com.codetaylor.mc.pyrotech.library.patreon.data.IEffectDataJsonProvider;
import com.codetaylor.mc.pyrotech.library.patreon.effect.EffectBase;
import com.codetaylor.mc.pyrotech.library.patreon.effect.EffectContainer;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraftforge.common.MinecraftForge;

public class EffectDataLoader {
    private final IEffectDataJsonProvider jsonProvider;
    private final IEffectDataJsonAdapter jsonAdapter;
    private final String modId;

    public EffectDataLoader(String modId, IEffectDataJsonProvider jsonProvider, IEffectDataJsonAdapter jsonAdapter) {
        this.modId = modId;
        this.jsonProvider = jsonProvider;
        this.jsonAdapter = jsonAdapter;
    }

    public void loadEffects() {
        EffectContainer.LOADING_FINISHED.put(this.modId, false);
        Thread thread = new Thread(() -> {
            Optional<Reader> optionalReader = this.jsonProvider.getEffectDataJson();
            if (!optionalReader.isPresent()) {
                EffectContainer.LOADING_FINISHED.put(this.modId, true);
                return;
            }
            Optional<EffectDataList> optionalEffectDataList = this.jsonAdapter.adaptJson(optionalReader.get());
            if (!optionalEffectDataList.isPresent()) {
                EffectContainer.LOADING_FINISHED.put(this.modId, true);
                return;
            }
            EffectDataList effectDataList = optionalEffectDataList.get();
            List<EffectDataBase> list = effectDataList.getEffectDataList();
            for (EffectDataBase effectData : list) {
                Object effect = effectData.createEffect();
                if (((EffectBase)effect).subscribeEvents()) {
                    MinecraftForge.EVENT_BUS.register(effect);
                }
                EffectContainer.EFFECTS.computeIfAbsent(this.modId, s -> new ArrayList()).add(effect);
                EffectContainer.LOADING_FINISHED.put(this.modId, true);
            }
        });
        thread.setName("EffectDataLoader");
        thread.run();
    }
}

