/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.library.config;

import com.codetaylor.mc.athenaeum.util.FileHelper;
import com.codetaylor.mc.pyrotech.library.config.SyncConfigField;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.Config;
import org.apache.logging.log4j.Logger;

public class ConfigSerializer {
    public static final ConfigSerializer INSTANCE = new ConfigSerializer();
    private static final boolean DEBUG = true;

    public void deserialize(Map<String, Map<String, byte[]>> configMap, Logger logger) {
        block4: for (Map.Entry<String, Map<String, byte[]>> entry : configMap.entrySet()) {
            Class<?> configClass;
            String className = entry.getKey();
            Map<String, byte[]> fieldMap = entry.getValue();
            try {
                configClass = Class.forName(className);
                System.out.println("De-serializing class " + configClass.getName());
            }
            catch (ClassNotFoundException e) {
                logger.error("Error retrieving config class for name: " + className, (Throwable)e);
                continue;
            }
            Field[] declaredFields = configClass.getDeclaredFields();
            for (Map.Entry<String, byte[]> fieldEntry : fieldMap.entrySet()) {
                String fieldName = "_" + fieldEntry.getKey();
                byte[] bytes = fieldEntry.getValue();
                Field declaredField = this.findDeclaredField(declaredFields, fieldName);
                if (declaredField == null) {
                    System.out.println("Unable to locate field for " + fieldName);
                    continue;
                }
                if (Modifier.isStatic(declaredField.getModifiers())) {
                    throw new RuntimeException("Field is not static: " + fieldName);
                }
                Object o = this.deserializeObject(bytes, logger);
                if (o == null) continue block4;
                try {
                    declaredField.set(null, o);
                    System.out.println("Assigned field " + fieldName);
                }
                catch (IllegalAccessException e) {
                    logger.error("Error assigning config declared field", (Throwable)e);
                }
                continue block4;
            }
        }
    }

    @Nullable
    private Field findDeclaredField(Field[] declaredFields, String fieldName) {
        for (Field declaredField : declaredFields) {
            if (!declaredField.getName().equals(fieldName)) continue;
            return declaredField;
        }
        return null;
    }

    public Map<String, Map<String, byte[]>> serialize(Class<?>[] configClasses, Logger logger) {
        HashMap<String, Map<String, byte[]>> serializedConfigs = new HashMap<String, Map<String, byte[]>>();
        for (Class<?> configClass : configClasses) {
            Map<String, byte[]> serializedConfig = this.serializeConfig(configClass, logger);
            if (serializedConfig.isEmpty()) continue;
            serializedConfigs.put(configClass.getName(), serializedConfig);
        }
        return serializedConfigs;
    }

    private Map<String, byte[]> serializeConfig(Class<?> configClass, Logger logger) {
        Field[] declaredFields = configClass.getDeclaredFields();
        HashMap<String, byte[]> fieldBytesMap = new HashMap<String, byte[]>();
        for (Field declaredField : declaredFields) {
            byte[] bytes;
            if (declaredField.getAnnotation(Config.Ignore.class) != null) {
                System.out.println("Has Config.Ignore annotation, skipping: " + declaredField.getName());
                continue;
            }
            SyncConfigField annotation = declaredField.getAnnotation(SyncConfigField.class);
            if (annotation == null) {
                System.out.println("Doesn't have SyncConfigField annotation, skipping: " + declaredField.getName());
                continue;
            }
            if (!Modifier.isStatic(declaredField.getModifiers()) || (bytes = this.serializeStaticField(declaredField, logger)).length <= 0) continue;
            fieldBytesMap.put(annotation.value(), bytes);
            System.out.println("Serialized " + declaredField.getName() + " to " + bytes.length + " bytes");
        }
        return fieldBytesMap;
    }

    private byte[] serializeStaticField(Field field, Logger logger) {
        if (Modifier.isStatic(field.getModifiers())) {
            try {
                return this.serializeObject(field.get(null), logger);
            }
            catch (IllegalAccessException e) {
                logger.error("Error serializing config field: " + field.getDeclaringClass() + "." + field.getName(), (Throwable)e);
            }
        }
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serializeObject(Object o, Logger logger) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(o);
            out.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            logger.error("Error serializing object", (Throwable)e);
        }
        finally {
            FileHelper.closeSilently((Closeable)bos);
        }
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T deserializeObject(byte[] bytes, Logger logger) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        try {
            ObjectInputStream in = new ObjectInputStream(bis);
            Object object = in.readObject();
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            logger.error("Error de-serializing object", (Throwable)e);
        }
        finally {
            FileHelper.closeSilently((Closeable)bis);
        }
        return null;
    }

    private ConfigSerializer() {
    }
}

