/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.library;

import com.codetaylor.mc.athenaeum.registry.Registry;
import com.codetaylor.mc.athenaeum.registry.strategy.IClientModelRegistrationStrategy;
import com.codetaylor.mc.athenaeum.registry.strategy.IForgeRegistryEventRegistrationStrategy;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FluidInitializerRegistry {
    private final List<Fluid> allFluidList = new ArrayList<Fluid>();
    private final List<IFluidBlock> modFluidBlockList = new ArrayList<IFluidBlock>();
    private final String modId;
    private final CreativeTabs creativeTab;

    public FluidInitializerRegistry(String modId, CreativeTabs creativeTab) {
        this.modId = modId;
        this.creativeTab = creativeTab;
    }

    public List<Fluid> getAllFluidList() {
        return this.allFluidList;
    }

    public List<IFluidBlock> getModFluidBlockList() {
        return this.modFluidBlockList;
    }

    public <T extends Block> Fluid createFluid(String name, boolean hasFlowIcon, Consumer<Fluid> fluidPropertyApplier, Function<Fluid, T> blockFactory) {
        ResourceLocation flowing;
        String texturePrefix = this.modId + ":blocks/fluid_";
        ResourceLocation still = new ResourceLocation(texturePrefix + name + "_still");
        Fluid fluid = new Fluid(name, still, flowing = hasFlowIcon ? new ResourceLocation(texturePrefix + name + "_flow") : still);
        boolean useOwnFluid = FluidRegistry.registerFluid((Fluid)fluid);
        if (useOwnFluid) {
            fluidPropertyApplier.accept(fluid);
            this.modFluidBlockList.add((IFluidBlock)blockFactory.apply(fluid));
        } else {
            fluid = FluidRegistry.getFluid((String)name);
        }
        this.allFluidList.add(fluid);
        return fluid;
    }

    public void registerClientModelRegistrationStrategies(Registry registry) {
        registry.registerClientModelRegistrationStrategy((IClientModelRegistrationStrategy)new FluidClientModelRegistrationStrategy(this.modId, this.getModFluidBlockList()));
    }

    public void registerRegistrationStrategies(Registry registry) {
        registry.registerBlockRegistrationStrategy((IForgeRegistryEventRegistrationStrategy)new FluidBlockRegistrationStrategy(this.modId, this.creativeTab, this.getModFluidBlockList()));
        registry.registerItemRegistrationStrategy((IForgeRegistryEventRegistrationStrategy)new FluidItemRegistrationStrategy(this.getModFluidBlockList(), this.getAllFluidList()));
    }

    public static class FluidClientModelRegistrationStrategy
    implements IClientModelRegistrationStrategy {
        private final String modId;
        private final List<IFluidBlock> modFluidBlockList;

        public FluidClientModelRegistrationStrategy(String modId, List<IFluidBlock> modFluidBlockList) {
            this.modId = modId;
            this.modFluidBlockList = modFluidBlockList;
        }

        public void register() {
            for (IFluidBlock fluidBlock : this.modFluidBlockList) {
                Item item = Item.func_150898_a((Block)((Block)fluidBlock));
                assert (item != Items.field_190931_a);
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
                final ModelResourceLocation modelResourceLocation = new ModelResourceLocation(this.modId + ":fluid", fluidBlock.getFluid().getName());
                ModelLoader.setCustomMeshDefinition((Item)item, stack -> modelResourceLocation);
                ModelLoader.setCustomStateMapper((Block)((Block)fluidBlock), (IStateMapper)new StateMapperBase(){

                    @Nonnull
                    protected ModelResourceLocation func_178132_a(@Nonnull IBlockState blockState) {
                        return modelResourceLocation;
                    }
                });
            }
        }
    }

    public static class FluidItemRegistrationStrategy
    implements IForgeRegistryEventRegistrationStrategy<Item> {
        private final List<IFluidBlock> modFluidBlockList;
        private final List<Fluid> allFluidList;

        public FluidItemRegistrationStrategy(List<IFluidBlock> modFluidBlockList, List<Fluid> allFluidList) {
            this.modFluidBlockList = modFluidBlockList;
            this.allFluidList = allFluidList;
        }

        public void register(IForgeRegistry<Item> registry) {
            for (IFluidBlock fluidBlock : this.modFluidBlockList) {
                Block block = (Block)fluidBlock;
                ItemBlock itemBlock = new ItemBlock(block);
                ResourceLocation registryName = (ResourceLocation)Preconditions.checkNotNull((Object)block.getRegistryName());
                itemBlock.setRegistryName(registryName);
                registry.register((IForgeRegistryEntry)itemBlock);
            }
            for (Fluid fluid : this.allFluidList) {
                FluidRegistry.addBucketForFluid((Fluid)fluid);
            }
        }
    }

    public static class FluidBlockRegistrationStrategy
    implements IForgeRegistryEventRegistrationStrategy<Block> {
        private final String modId;
        private final List<IFluidBlock> modFluidBlockList;
        private final CreativeTabs creativeTab;

        public FluidBlockRegistrationStrategy(String modId, CreativeTabs creativeTab, List<IFluidBlock> modFluidBlockList) {
            this.modId = modId;
            this.modFluidBlockList = modFluidBlockList;
            this.creativeTab = creativeTab;
        }

        public void register(IForgeRegistry<Block> registry) {
            for (IFluidBlock fluidBlock : this.modFluidBlockList) {
                Block block = (Block)fluidBlock;
                block.setRegistryName(this.modId, "fluid." + fluidBlock.getFluid().getName());
                block.func_149663_c(fluidBlock.getFluid().getUnlocalizedName());
                block.func_149647_a(this.creativeTab);
                registry.register((IForgeRegistryEntry)block);
            }
        }
    }
}

