/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.defaultworldgenerator.gui;

import com.ezrol.terry.minecraft.defaultworldgenerator.config.StringListTypeNode;
import java.io.IOException;
import java.util.function.Function;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;

public class StringListGui
extends GuiScreen {
    private StringListTypeNode activeNode;
    private GuiScreen parent;
    private StringSlotList list = null;
    private String title;
    private Function<String, Boolean> filter;
    private static final int BTN_OK = 400;
    private static final int BTN_ADD = 401;
    private static final int BTN_REMOVE = 402;
    private static final int TXT_EDITBOX = 403;
    private String currentText;
    private GuiTextField newStringField;

    public StringListGui(GuiScreen par, StringListTypeNode node, String title, Function<String, Boolean> filter) {
        this.activeNode = node;
        this.parent = par;
        this.title = title;
        this.filter = filter == null ? s -> true : filter;
        this.currentText = "";
    }

    public void func_73866_w_() {
        int idx = this.list == null ? -1 : this.list.selected;
        this.list = new StringSlotList(this.field_146294_l, this.field_146295_m);
        this.list.selected = idx;
        this.field_146292_n.add(new GuiButton(400, this.field_146294_l / 4 + 20, this.field_146295_m - 28, this.field_146294_l / 2 - 40, 18, I18n.func_135052_a((String)"defaultworldgenerator-port.config.btn.ok", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(401, this.field_146294_l / 2 + 10, this.field_146295_m - 48, 100, 18, I18n.func_135052_a((String)"defaultworldgenerator-port.config.btn.strings.add", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(402, this.field_146294_l / 2 - 110, this.field_146295_m - 48, 100, 18, I18n.func_135052_a((String)"defaultworldgenerator-port.config.btn.strings.remove", (Object[])new Object[0])));
        this.newStringField = new GuiTextField(403, this.field_146289_q, 50, 26, this.field_146294_l - 100, 18);
        this.newStringField.func_146203_f(65535);
        this.newStringField.func_146180_a(this.currentText);
        this.newStringField.func_175207_a(new GuiPageButtonList.GuiResponder(){

            public void func_175321_a(int id, boolean value) {
            }

            public void func_175320_a(int id, float value) {
            }

            public void func_175319_a(int id, String value) {
                StringListGui.this.currentText = value;
                StringListGui.this.updateButtons();
            }
        });
        this.newStringField.func_146196_d();
        this.updateButtons();
    }

    private void updateButtons() {
        for (GuiButton b : this.field_146292_n) {
            if (b.field_146127_k == 401) {
                b.field_146124_l = this.currentText.length() > 0 && this.filter.apply(this.currentText) != false;
                b.field_146126_j = this.list.selected != -1 ? I18n.func_135052_a((String)"defaultworldgenerator-port.config.btn.strings.replace", (Object[])new Object[0]) : I18n.func_135052_a((String)"defaultworldgenerator-port.config.btn.strings.add", (Object[])new Object[0]);
            }
            if (b.field_146127_k != 402) continue;
            b.field_146124_l = this.list.selected >= 0 && this.list.selected < this.activeNode.getValue().size();
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 400: {
                this.exitScreen();
                break;
            }
            case 401: {
                if (this.currentText.length() > 0 && this.filter.apply(this.currentText).booleanValue()) {
                    if (this.list.selected < 0 || this.list.selected >= this.activeNode.getValue().size()) {
                        this.activeNode.getValue().add(this.currentText);
                    } else {
                        this.activeNode.getValue().remove(this.list.selected);
                        this.activeNode.getValue().add(this.list.selected, this.currentText);
                    }
                    this.list.selected = -1;
                    this.currentText = "";
                    this.newStringField.func_146180_a("");
                }
                this.updateButtons();
                break;
            }
            case 402: {
                if (this.list.selected >= 0 && this.list.selected < this.activeNode.getValue().size()) {
                    this.activeNode.getValue().remove(this.list.selected);
                    this.list.selected = -1;
                    this.currentText = "";
                    this.newStringField.func_146180_a("");
                }
                this.updateButtons();
            }
        }
    }

    private void exitScreen() {
        this.field_146297_k.func_147108_a(this.parent);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.list.func_148128_a(mouseX, mouseY, partialTicks);
        Gui.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)50, (int)-16777216);
        Gui.func_73734_a((int)0, (int)(this.field_146295_m - 50), (int)this.field_146294_l, (int)this.field_146295_m, (int)-16777216);
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 8, 0xFFFFFF);
        this.newStringField.func_146194_f();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_73876_c() {
        this.newStringField.func_146178_a();
        super.func_73876_c();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.newStringField.func_146192_a(mouseX, mouseY, mouseButton);
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.newStringField.func_146201_a(typedChar, keyCode)) {
            return;
        }
        if (keyCode == 1) {
            this.exitScreen();
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.list.func_178039_p();
    }

    private class StringSlotList
    extends GuiSlot {
        int selected;

        private StringSlotList(int screen_width, int screen_height) {
            super(StringListGui.this.field_146297_k, screen_width, screen_height - 50, 50, 50, 18);
            this.selected = -1;
            this.field_148152_e = 8;
            this.field_148151_d = screen_width - 8;
            this.field_148155_a = screen_width - 16;
            this.field_148153_b = 50;
            this.field_148158_l = this.field_148154_c = screen_height - 50;
        }

        protected int func_148127_b() {
            return StringListGui.this.activeNode.getValue().size();
        }

        protected void func_148144_a(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
            this.selected = slotIndex;
            StringListGui.this.updateButtons();
            StringListGui.this.currentText = StringListGui.this.activeNode.getValue().get(slotIndex);
            StringListGui.this.newStringField.func_146180_a(StringListGui.this.currentText);
        }

        protected boolean func_148131_a(int slotIndex) {
            return slotIndex == this.selected;
        }

        protected void func_148123_a() {
            StringListGui.this.func_146276_q_();
        }

        protected void func_192637_a(int entryID, int insideLeft, int yPos, int insideSlotHeight, int mouseXIn, int mouseYIn, float partialTicks) {
            String s = StringListGui.this.activeNode.getValue().get(entryID);
            StringListGui.this.field_146289_q.func_78276_b(s, insideLeft + 10, yPos + 4, 0xEEEEEE);
        }

        public int func_148139_c() {
            if (this.func_148135_f() > 0) {
                return this.field_148155_a - 8;
            }
            return this.field_148155_a;
        }

        protected int func_148137_d() {
            return this.field_148151_d - 4;
        }
    }
}

