/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.defaultworldgenerator.datapack;

import com.ezrol.terry.lib.huffstruct.Huffstruct;
import com.ezrol.terry.minecraft.defaultworldgenerator.DefaultWorldGenerator;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.ConfigurationFile;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.StringListTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.UuidTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.WorldTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.datapack.RuntimeSettings;
import com.ezrol.terry.minecraft.defaultworldgenerator.lib.Log;
import com.ezrol.terry.minecraft.defaultworldgenerator.lib.Sha384;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.storage.ISaveHandler;

public class WorldWrapper {
    private File runtimeSettingFile;
    private RuntimeSettings settings = null;
    private WorldTypeNode worldConfig;

    public WorldWrapper(ISaveHandler worldSave) {
        this.runtimeSettingFile = new File(worldSave.func_75765_b(), "state.defaultworldgenerator-port.data");
        this.internalInit();
    }

    public WorldWrapper(File worldDirectory) {
        this.runtimeSettingFile = new File(worldDirectory, "state.defaultworldgenerator-port.data");
        this.internalInit();
    }

    private void internalInit() {
        if (this.runtimeSettingFile.exists()) {
            try {
                byte[] currentData = Files.readAllBytes(this.runtimeSettingFile.toPath());
                this.settings = new RuntimeSettings(Huffstruct.loadData(currentData));
            }
            catch (IOException e) {
                Log.error("Error reading in runtime settings: " + this.runtimeSettingFile.toString());
            }
        }
        if (this.settings == null) {
            Log.info("Generating new runtime file for the world");
            this.settings = new RuntimeSettings(null);
            if (DefaultWorldGenerator.selectedLevel != null) {
                this.settings.setSaveUUID(((UuidTypeNode)DefaultWorldGenerator.selectedLevel.getField(WorldTypeNode.Fields.UUID)).getValue());
            }
        }
        this.worldConfig = DefaultWorldGenerator.modConfig.lookupUUID(this.settings.getSaveUUID()).orElse(DefaultWorldGenerator.modConfig.getSettings().getWorldList().get(0));
        UuidTypeNode worldUUID = (UuidTypeNode)this.worldConfig.getField(WorldTypeNode.Fields.UUID);
        if (worldUUID.getValue() != this.settings.getSaveUUID()) {
            this.settings.setSaveUUID(worldUUID.getValue());
        }
        DefaultWorldGenerator.selectedLevel = null;
    }

    public WorldTypeNode getWorldType() {
        return this.worldConfig;
    }

    public void saveWorldData() {
        byte[] tmp = Huffstruct.dumpData(this.settings);
        try {
            this.runtimeSettingFile.getParentFile().mkdirs();
            Files.write(this.runtimeSettingFile.toPath(), tmp, new OpenOption[0]);
        }
        catch (IOException e) {
            Log.error(String.format("Error writing file %s: %s", this.runtimeSettingFile.getName(), e.toString()));
        }
    }

    private Map<String, File> dataPackList(String name) {
        HashMap<String, File> rval = new HashMap<String, File>();
        LinkedList<File> cwd = new LinkedList<File>();
        if (ConfigurationFile.safeFileName(name)) {
            File basePath = new File(DefaultWorldGenerator.modSettingsDir, name);
            cwd.addFirst(basePath);
            while (cwd.size() > 0) {
                File dir = (File)cwd.pop();
                String[] dirlist = dir.list();
                if (dirlist == null || dirlist.length == 0) continue;
                for (String el : dirlist) {
                    File file = new File(dir, el);
                    if (file.getName().equals(".") || file.getName().equals("..")) continue;
                    if (file.isDirectory()) {
                        cwd.addLast(file);
                        continue;
                    }
                    if (!file.isFile()) continue;
                    if (file.getAbsolutePath().startsWith(basePath.getAbsolutePath())) {
                        String w = file.getAbsolutePath().substring(basePath.getAbsolutePath().length());
                        if (w.startsWith("/")) {
                            w = w.substring(1);
                        }
                        rval.put(w, file);
                        continue;
                    }
                    throw new RuntimeException("child path not in base path (" + file.getAbsolutePath() + " under " + basePath.getAbsolutePath());
                }
            }
        }
        return rval;
    }

    private boolean canOverwrite(File filename) {
        if (filename.getName().endsWith(".mca") || filename.getName().endsWith(".dat") || filename.getName().endsWith(".lock") || filename.getName().endsWith("defaultworldgenerator-port.data")) {
            return false;
        }
        return !filename.getParentFile().getName().endsWith("stats") && !filename.getParentFile().getName().endsWith("playerdata") && !filename.getParentFile().getName().endsWith("advancements");
    }

    public void importData() {
        File target;
        boolean modified = false;
        HashMap<String, File> fullList = new HashMap<String, File>();
        for (String dataPack : ((StringListTypeNode)this.worldConfig.getField(WorldTypeNode.Fields.DATA_PACKS)).getValue()) {
            fullList.putAll(this.dataPackList(dataPack));
        }
        List<String> missing = this.settings.findMissing(fullList);
        for (String m : missing) {
            target = new File(this.runtimeSettingFile.toPath().getParent().toFile(), m);
            if (!target.exists() || !this.canOverwrite(target)) continue;
            Log.warn("Deleting " + target.getAbsolutePath());
            Log.warn("Data Pack File removed from upstream datapack, deleting local copy");
            if (!target.delete()) {
                Log.error("Unable to delete datapack file");
                continue;
            }
            modified = true;
        }
        for (String p : fullList.keySet()) {
            target = new File(this.runtimeSettingFile.toPath().getParent().toFile(), p);
            Sha384 currentChecksum = new Sha384((File)fullList.get(p));
            if (target.exists()) {
                if (!this.canOverwrite(target) || this.settings.getCachedChecksum(p).equals(currentChecksum.getHexDigest())) continue;
                try {
                    Log.warn("Overwriting " + target.getAbsolutePath());
                    Files.copy(((File)fullList.get(p)).toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    this.settings.updateChecksum(p, currentChecksum.getHexDigest());
                    modified = true;
                }
                catch (IOException e) {
                    Log.error("Unable to install file: " + p);
                    Log.error(e);
                }
                continue;
            }
            target.getParentFile().mkdirs();
            try {
                Log.info("Installing " + target.getAbsolutePath());
                Files.copy(((File)fullList.get(p)).toPath(), target.toPath(), new CopyOption[0]);
                this.settings.updateChecksum(p, currentChecksum.getHexDigest());
            }
            catch (IOException e) {
                Log.error("Unable to install file: " + p);
                Log.error(e);
            }
        }
        if (modified) {
            Log.warn("*********************************************************");
            Log.warn("data pack files updated, if you manually changed a");
            Log.warn("file used by this modpack, you will need to re-install");
            Log.warn("such changes by hand from backup");
            Log.warn("*********************************************************");
        }
    }
}

