/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.defaultworldgenerator.config;

import com.ezrol.terry.lib.huffstruct.StructNode;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StringListTypeNode
extends StructNode {
    private List<String> value;
    private Charset utf8 = Charset.forName("UTF-8");

    public StringListTypeNode(StructNode base, String[] def) {
        if (base == null || base.getArray() == null) {
            this.value = new ArrayList<String>(Arrays.asList(def));
        } else {
            this.value = new ArrayList<String>();
            for (StructNode n : base.getArray()) {
                if (n.getBinaryString() == null) break;
                this.value.add(new String(n.getBinaryString(), this.utf8));
            }
        }
    }

    @Override
    public List<StructNode> getArray() {
        ArrayList<StructNode> ret = new ArrayList<StructNode>();
        for (String s : this.value) {
            ret.add(StructNode.newBinaryString(s.getBytes(this.utf8)));
        }
        return ret;
    }

    @Override
    public byte[] getBinaryString() {
        return null;
    }

    public List<String> getValue() {
        return this.value;
    }

    public String toString() {
        return "StringListTypeNode{value=" + this.value + '}';
    }
}

