/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.patch.packetsize;

import com.therandomlabs.randompatches.config.RPConfig;
import com.therandomlabs.randompatches.core.Patch;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;

public final class NettyCompressionDecoderPatch
extends Patch {
    public static final String MISC_CONFIG = NettyCompressionDecoderPatch.getName(RPConfig.Misc.class);
    public static final int VANILLA_LIMIT = 0x200000;

    @Override
    public boolean apply(ClassNode node) {
        InsnList instructions = NettyCompressionDecoderPatch.findInstructions(node, "decode");
        LdcInsnNode limit1 = null;
        LdcInsnNode limit2 = null;
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractInsnNode instruction = instructions.get(i);
            if (instruction.getOpcode() != 18) continue;
            LdcInsnNode ldc = (LdcInsnNode)instruction;
            if (!Integer.valueOf(0x200000).equals(ldc.cst)) continue;
            if (limit1 == null) {
                limit1 = ldc;
                continue;
            }
            limit2 = ldc;
            break;
        }
        instructions.insert(limit1, (AbstractInsnNode)new FieldInsnNode(178, MISC_CONFIG, "packetSizeLimit", "I"));
        instructions.remove(limit1);
        instructions.insert((AbstractInsnNode)limit2, (AbstractInsnNode)new FieldInsnNode(178, MISC_CONFIG, "packetSizeLimit", "I"));
        instructions.remove((AbstractInsnNode)limit2);
        return true;
    }
}

