/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweakercore.module;

import me.superckl.biometweakercore.BiomeTweakerCore;
import me.superckl.biometweakercore.module.IClassTransformerModule;
import me.superckl.biometweakercore.util.ASMHelper;
import me.superckl.biometweakercore.util.ObfNameHelper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ModuleBiome
implements IClassTransformerModule {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        ClassNode cNode = ASMHelper.readClassFromBytes(bytes);
        BiomeTweakerCore.logger.info("Attempting to patch class " + transformedName + "...");
        int fixed = 0;
        int expected = 0;
        if (BiomeTweakerCore.config.isActualFillerBlocks()) {
            ++expected;
            cNode.fields.add(ObfNameHelper.Fields.ACTUALFILLERBLOCKS.toNode(1, null));
            BiomeTweakerCore.logger.debug("Successfully inserted 'actualFillerBlocks' field into " + transformedName);
            ++fixed;
        }
        if (BiomeTweakerCore.config.isOceanTopBlock()) {
            ++expected;
            cNode.fields.add(ObfNameHelper.Fields.OCEANTOPBLOCK.toNode(1, null));
            BiomeTweakerCore.logger.debug("Successfully inserted 'oceanTopBlock' field into " + transformedName);
            ++fixed;
        }
        if (BiomeTweakerCore.config.isOceanFillerBlock()) {
            ++expected;
            cNode.fields.add(ObfNameHelper.Fields.OCEANFILLERBLOCK.toNode(1, null));
            BiomeTweakerCore.logger.debug("Successfully inserted 'oceanFillerBlock' field into " + transformedName);
            ++fixed;
        }
        if (BiomeTweakerCore.config.isGrassColor()) {
            ++expected;
            cNode.fields.add(ObfNameHelper.Fields.GRASSCOLOR.toNode(1, -1));
            BiomeTweakerCore.logger.debug("Successfully inserted 'grassColor' field into " + transformedName);
            ++fixed;
        }
        if (BiomeTweakerCore.config.isFoliageColor()) {
            ++expected;
            cNode.fields.add(ObfNameHelper.Fields.FOLIAGECOLOR.toNode(1, -1));
            BiomeTweakerCore.logger.debug("Successfully inserted 'foliageColor' field into " + transformedName);
            ++fixed;
        }
        if (BiomeTweakerCore.config.isSkyColor()) {
            ++expected;
            cNode.fields.add(ObfNameHelper.Fields.SKYCOLOR.toNode(1, -1));
            BiomeTweakerCore.logger.debug("Successfully inserted 'skyColor' field into " + transformedName);
            ++fixed;
        }
        if (BiomeTweakerCore.config.isFogColor()) {
            ++expected;
            cNode.fields.add(ObfNameHelper.Fields.FOGCOLOR.toNode(1, -1));
            BiomeTweakerCore.logger.debug("Successfully inserted 'fogColor' field into " + transformedName);
            ++fixed;
        }
        if (BiomeTweakerCore.config.isInitialSnow()) {
            ++expected;
            cNode.fields.add(ObfNameHelper.Fields.GENINITIALSNOW.toNode(1, null));
            BiomeTweakerCore.logger.debug("Successfully inserted 'genInitialSnow' field into " + transformedName);
            ++fixed;
        }
        boolean sky = false;
        for (MethodNode node : cNode.methods) {
            InsnList list;
            if (ObfNameHelper.Methods.GENBIOMETERRAIN.matches(node)) {
                AbstractInsnNode aaNode;
                InsnList toInsert;
                InsnList toFind;
                if (BiomeTweakerCore.config.isActualFillerBlocks()) {
                    AbstractInsnNode someNode;
                    ++expected;
                    toFind = new InsnList();
                    toFind.add((AbstractInsnNode)new VarInsnNode(25, 17));
                    toFind.add((AbstractInsnNode)ObfNameHelper.Methods.GETBLOCK.toInsnNode(185));
                    toFind.add((AbstractInsnNode)ObfNameHelper.Fields.STONE.toInsnNode(178));
                    AbstractInsnNode found = ASMHelper.find(node.instructions, toFind);
                    if (found != null && (someNode = found.getNext().getNext().getNext()) instanceof JumpInsnNode && someNode.getOpcode() == 166) {
                        ((JumpInsnNode)someNode).setOpcode(153);
                        toInsert = new InsnList();
                        toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        toInsert.add((AbstractInsnNode)ObfNameHelper.Fields.ACTUALFILLERBLOCKS.toInsnNode(180));
                        toInsert.add((AbstractInsnNode)new VarInsnNode(25, 17));
                        toInsert.add((AbstractInsnNode)ObfNameHelper.Methods.CONTAINS.toInsnNode(184));
                        if (ASMHelper.findAndReplace(node.instructions, toFind, toInsert) != null) {
                            BiomeTweakerCore.logger.debug("Successfully redirected 'Stone' check to 'contains' method.");
                            ++fixed;
                        }
                    }
                }
                if (!BiomeTweakerCore.config.isOceanFillerBlock() && !BiomeTweakerCore.config.isOceanTopBlock()) continue;
                toFind = new InsnList();
                toFind.add((AbstractInsnNode)new VarInsnNode(25, 3));
                toFind.add((AbstractInsnNode)new VarInsnNode(21, 14));
                toFind.add((AbstractInsnNode)new VarInsnNode(21, 16));
                toFind.add((AbstractInsnNode)new VarInsnNode(21, 13));
                toFind.add((AbstractInsnNode)ObfNameHelper.Fields.BIOMEGENBASE_GRAVEL.toInsnNode(178));
                toFind.add((AbstractInsnNode)ObfNameHelper.Methods.SETBLOCKSTATE.toInsnNode(182));
                AbstractInsnNode aNode = ASMHelper.find(node.instructions, toFind);
                if (aNode == null || (aaNode = ASMHelper.findNextInstructionWithOpcode(aNode, 178)) == null) continue;
                if (BiomeTweakerCore.config.isOceanTopBlock()) {
                    ++expected;
                    toInsert = new InsnList();
                    toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    toInsert.add((AbstractInsnNode)ObfNameHelper.Fields.OCEANTOPBLOCK.toInsnNode(180));
                    node.instructions.insert(aaNode, toInsert);
                    node.instructions.remove(aaNode);
                    BiomeTweakerCore.logger.debug("Successfully inserted 'oceanTopBlock' instructions.");
                    ++fixed;
                }
                if (!BiomeTweakerCore.config.isOceanFillerBlock()) continue;
                ++expected;
                aNode = ASMHelper.findPreviousInstructionWithOpcode(aNode, 178);
                toFind = new InsnList();
                toFind.add((AbstractInsnNode)ObfNameHelper.Fields.BIOMEGENBASE_STONE.toInsnNode(178));
                toFind.add((AbstractInsnNode)new VarInsnNode(58, 10));
                if ((aNode = ASMHelper.find(aNode, toFind)) == null) continue;
                InsnList toInsert1 = new InsnList();
                toInsert1.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert1.add((AbstractInsnNode)ObfNameHelper.Fields.OCEANFILLERBLOCK.toInsnNode(180));
                node.instructions.insert(aNode, toInsert1);
                node.instructions.remove(aNode);
                BiomeTweakerCore.logger.debug("Successfully inserted 'oceanFillerBlock' instructions.");
                ++fixed;
                continue;
            }
            if (BiomeTweakerCore.config.isSkyColor() && ObfNameHelper.Methods.GETSKYCOLORBYTEMP.matches(node)) {
                list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)ObfNameHelper.Fields.SKYCOLOR.toInsnNode(180));
                list.add((AbstractInsnNode)new InsnNode(2));
                LabelNode label = new LabelNode();
                list.add((AbstractInsnNode)new JumpInsnNode(159, label));
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)ObfNameHelper.Fields.SKYCOLOR.toInsnNode(180));
                list.add((AbstractInsnNode)new InsnNode(172));
                list.add((AbstractInsnNode)label);
                list.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
                node.instructions.insertBefore(node.instructions.getFirst(), list);
                BiomeTweakerCore.logger.debug("Successfully inserted sky color instructions.");
                sky = true;
                continue;
            }
            if (!ObfNameHelper.Methods.BIOME_CONSTRUCTOR.matches(node)) continue;
            if (BiomeTweakerCore.config.isActualFillerBlocks()) {
                ++expected;
                list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new InsnNode(4));
                list.add((AbstractInsnNode)new TypeInsnNode(189, ObfNameHelper.Classes.IBLOCKSTATE.getInternalName()));
                list.add((AbstractInsnNode)new InsnNode(89));
                list.add((AbstractInsnNode)new InsnNode(3));
                list.add((AbstractInsnNode)ObfNameHelper.Fields.STONE.toInsnNode(178));
                list.add((AbstractInsnNode)ObfNameHelper.Methods.GETDEFAULTSTATE.toInsnNode(182));
                list.add((AbstractInsnNode)new InsnNode(83));
                list.add((AbstractInsnNode)ObfNameHelper.Fields.ACTUALFILLERBLOCKS.toInsnNode(181));
                node.instructions.insert(list);
                BiomeTweakerCore.logger.debug("Successfully inserted empty array into 'actualFillerBlocks'");
                ++fixed;
            }
            if (BiomeTweakerCore.config.isOceanFillerBlock()) {
                ++expected;
                list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)ObfNameHelper.Fields.BIOMEGENBASE_STONE.toInsnNode(178));
                list.add((AbstractInsnNode)ObfNameHelper.Fields.OCEANFILLERBLOCK.toInsnNode(181));
                node.instructions.insert(list);
                BiomeTweakerCore.logger.debug("Successfully inserted stone into 'oceanFillerBlock'");
                ++fixed;
            }
            if (BiomeTweakerCore.config.isOceanTopBlock()) {
                ++expected;
                list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)ObfNameHelper.Fields.BIOMEGENBASE_GRAVEL.toInsnNode(178));
                list.add((AbstractInsnNode)ObfNameHelper.Fields.OCEANTOPBLOCK.toInsnNode(181));
                node.instructions.insert(list);
                BiomeTweakerCore.logger.debug("Successfully inserted gravel into 'oceanTopBlock'");
                ++fixed;
            }
            if (BiomeTweakerCore.config.isGrassColor()) {
                ++expected;
                list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new InsnNode(2));
                list.add((AbstractInsnNode)ObfNameHelper.Fields.GRASSCOLOR.toInsnNode(181));
                node.instructions.insert(list);
                BiomeTweakerCore.logger.debug("Successfully inserted -1 into 'grassColor'");
                ++fixed;
            }
            if (BiomeTweakerCore.config.isFoliageColor()) {
                ++expected;
                list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new InsnNode(2));
                list.add((AbstractInsnNode)ObfNameHelper.Fields.FOLIAGECOLOR.toInsnNode(181));
                node.instructions.insert(list);
                BiomeTweakerCore.logger.debug("Successfully inserted -1 into 'foliageColor'");
                ++fixed;
            }
            if (BiomeTweakerCore.config.isSkyColor()) {
                ++expected;
                list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new InsnNode(2));
                list.add((AbstractInsnNode)ObfNameHelper.Fields.SKYCOLOR.toInsnNode(181));
                node.instructions.insert(list);
                BiomeTweakerCore.logger.debug("Successfully inserted -1 into 'skyColor'");
                ++fixed;
            }
            if (!BiomeTweakerCore.config.isFogColor()) continue;
            ++expected;
            list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new InsnNode(2));
            list.add((AbstractInsnNode)ObfNameHelper.Fields.FOGCOLOR.toInsnNode(181));
            node.instructions.insert(list);
            BiomeTweakerCore.logger.debug("Successfully inserted -1 into 'fogColor'");
            ++fixed;
        }
        if (BiomeTweakerCore.config.isSkyColor() && !sky) {
            BiomeTweakerCore.logger.warn("Failed to insert sky color instructions. If this is a server, don't worry. If if this a client, worry. A lot.");
        }
        if (fixed < expected) {
            BiomeTweakerCore.logger.error("Failed to completely patch " + transformedName + "! Only " + fixed + " patches were processed. Ye who continue now abandon all hope.");
            BiomeTweakerCore.logger.error("Seriously, this is really bad. Things are probably going to break.");
        } else if (fixed > expected) {
            BiomeTweakerCore.logger.warn("Sucessfully patched " + transformedName + ", but " + fixed + " patches were applied when we were expecting " + expected + ". Is something else also patching this class?");
        } else {
            BiomeTweakerCore.logger.info("Sucessfully patched " + transformedName + "! " + fixed + " patches were applied.");
        }
        return ASMHelper.writeClassToBytes(cNode);
    }

    @Override
    public String[] getClassesToTransform() {
        return new String[]{ObfNameHelper.Classes.BIOME.getName()};
    }

    @Override
    public String getModuleName() {
        return "moduleTransformBiome";
    }

    @Override
    public boolean isRequired() {
        return true;
    }
}

