/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.scalar;

import com.cleanroommc.scalar.ScalarLoadingPlugin;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.ILanguageAdapter;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.relauncher.Side;

public class ScalaLanguageAdapter
implements ILanguageAdapter {
    public Object getNewInstance(FMLModContainer container, Class<?> objectClass, ClassLoader classLoader, Method factoryMarkedAnnotation) throws Exception {
        Class<?> sObjectClass = Class.forName(objectClass.getName() + "$", true, classLoader);
        return sObjectClass.getField("MODULE$").get(null);
    }

    public boolean supportsStatics() {
        return false;
    }

    public void setProxy(Field target, Class<?> proxyTarget, Object proxy) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        try {
            if (!proxyTarget.getName().endsWith("$")) {
                proxyTarget = Class.forName(proxyTarget.getName() + "$", true, proxyTarget.getClassLoader());
            }
        }
        catch (ClassNotFoundException e) {
            ScalarLoadingPlugin.LOGGER.info("An error occurred trying to load a proxy into {}.{}. Did you declare your mod as 'class' instead of 'object'?", (Object)proxyTarget.getSimpleName(), (Object)target.getName(), (Object)e);
            return;
        }
        Object targetInstance = proxyTarget.getField("MODULE$").get(null);
        try {
            String setterName = target.getName() + "_$eq";
            for (Method setter : proxyTarget.getMethods()) {
                Class<?>[] setterParameters = setter.getParameterTypes();
                if (!setterName.equals(setter.getName()) || setterParameters.length != 1 || !setterParameters[0].isAssignableFrom(proxy.getClass())) continue;
                setter.invoke(targetInstance, proxy);
                return;
            }
        }
        catch (InvocationTargetException e) {
            ScalarLoadingPlugin.LOGGER.error("An error occurred trying to load a proxy into {}.{}", (Object)proxyTarget.getSimpleName(), (Object)target.getName(), (Object)e);
            throw new LoaderException((Throwable)e);
        }
        ScalarLoadingPlugin.LOGGER.fatal("Failed loading proxy into {}.{}, could not find setter function. Did you declare the field with 'val' instead of 'var'?", (Object)proxyTarget.getSimpleName(), (Object)target.getName());
        throw new LoaderException(String.format("Failed loading proxy into %s.%s, could not find setter function. Did you declare the field with 'val' instead of 'var'?", proxyTarget.getSimpleName(), target.getName()));
    }

    public void setInternalProxies(ModContainer mod, Side side, ClassLoader loader) {
        Class<?> proxyTarget = mod.getMod().getClass();
        if (proxyTarget.getName().endsWith("$")) {
            for (Field target : proxyTarget.getDeclaredFields()) {
                if (target.getAnnotation(SidedProxy.class) == null) continue;
                String targetType = side.isClient() ? target.getAnnotation(SidedProxy.class).clientSide() : target.getAnnotation(SidedProxy.class).serverSide();
                try {
                    Object proxy = Class.forName(targetType, true, loader).newInstance();
                    if (!target.getType().isAssignableFrom(proxy.getClass())) {
                        ScalarLoadingPlugin.LOGGER.fatal("Attempted to load a proxy type {} into {}.{}, but the types don't match", (Object)targetType, (Object)proxyTarget.getSimpleName(), (Object)target.getName());
                        throw new LoaderException(String.format("Attempted to load a proxy type %s into %s.%s, but the types don't match", targetType, proxyTarget.getSimpleName(), target.getName()));
                    }
                    this.setProxy(target, proxyTarget, proxy);
                }
                catch (Exception e) {
                    ScalarLoadingPlugin.LOGGER.error("An error occurred trying to load a proxy into {}.{}", (Object)proxyTarget.getSimpleName(), (Object)target.getName(), (Object)e);
                    throw new LoaderException((Throwable)e);
                }
            }
        } else {
            ScalarLoadingPlugin.LOGGER.trace("Mod does not appear to be a singleton.");
        }
    }
}

