/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.network;

import com.cleanroommc.bogosorter.common.network.CConfigSync;
import com.cleanroommc.bogosorter.common.network.CHotbarSwap;
import com.cleanroommc.bogosorter.common.network.CShortcut;
import com.cleanroommc.bogosorter.common.network.CSlotSync;
import com.cleanroommc.bogosorter.common.network.CSort;
import com.cleanroommc.bogosorter.common.network.IPacket;
import com.cleanroommc.bogosorter.common.network.SRefillSound;
import com.cleanroommc.bogosorter.common.network.SReloadConfig;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.IThreadListener;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class NetworkHandler {
    public static final SimpleNetworkWrapper network = NetworkRegistry.INSTANCE.newSimpleChannel("bogosorter");
    private static int packetId = 0;
    static final IMessageHandler<IPacket, IPacket> S2CHandler = (message, ctx) -> {
        NetHandlerPlayClient handler = ctx.getClientHandler();
        IThreadListener threadListener = FMLCommonHandler.instance().getWorldThread((INetHandler)handler);
        if (threadListener.func_152345_ab()) {
            return message.executeClient(handler);
        }
        threadListener.func_152344_a(() -> message.executeClient(handler));
        return null;
    };
    static final IMessageHandler<IPacket, IPacket> C2SHandler = (message, ctx) -> {
        NetHandlerPlayServer handler = ctx.getServerHandler();
        IThreadListener threadListener = FMLCommonHandler.instance().getWorldThread((INetHandler)handler);
        if (threadListener.func_152345_ab()) {
            return message.executeServer(handler);
        }
        threadListener.func_152344_a(() -> message.executeServer(handler));
        return null;
    };

    public static void init() {
        NetworkHandler.registerC2S(CSlotSync.class);
        NetworkHandler.registerC2S(CShortcut.class);
        NetworkHandler.registerC2S(CConfigSync.class);
        NetworkHandler.registerC2S(CSort.class);
        NetworkHandler.registerC2S(CHotbarSwap.class);
        NetworkHandler.registerS2C(SReloadConfig.class);
        NetworkHandler.registerS2C(SRefillSound.class);
    }

    private static void registerC2S(Class<? extends IPacket> clazz) {
        network.registerMessage(C2SHandler, clazz, packetId++, Side.SERVER);
    }

    private static void registerS2C(Class<? extends IPacket> clazz) {
        network.registerMessage(S2CHandler, clazz, packetId++, Side.CLIENT);
    }

    public static void sendToServer(IPacket packet) {
        network.sendToServer((IMessage)packet);
    }

    public static void sendToWorld(IPacket packet, World world) {
        network.sendToDimension((IMessage)packet, world.field_73011_w.getDimension());
    }

    public static void sendToPlayer(IPacket packet, EntityPlayerMP player) {
        network.sendTo((IMessage)packet, player);
    }
}

