/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.dropt.modules.dropt.rule.parse;

import com.codetaylor.mc.athenaeum.parser.recipe.item.MalformedRecipeItemException;
import com.codetaylor.mc.athenaeum.parser.recipe.item.ParseResult;
import com.codetaylor.mc.athenaeum.parser.recipe.item.RecipeItemParser;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.DebugFileWrapper;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.ILogger;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

public class ParserUtil {
    public static NBTParseResult parseWithNBT(String itemString, ILogger logger) throws MalformedRecipeItemException {
        NBTTagCompound tag = null;
        String[] split = itemString.split("#");
        String actualItemString = split[0];
        if (split.length > 1) {
            String[] nbtSplit;
            String nbtString = split[1];
            if (split.length > 2) {
                StringBuilder sb = new StringBuilder(nbtString);
                for (int i = 2; i < split.length; ++i) {
                    sb.append("#").append(split[i]);
                }
                nbtString = sb.toString();
            }
            if ((nbtSplit = nbtString.split("\\*")).length > 1) {
                int nbtSplitLength = nbtSplit.length;
                try {
                    int quantity = Integer.parseInt(nbtSplit[nbtSplit.length - 1].trim());
                    actualItemString = actualItemString + " * " + quantity;
                    --nbtSplitLength;
                }
                catch (NumberFormatException quantity) {
                    // empty catch block
                }
                StringBuilder sb = new StringBuilder(nbtSplit[0]);
                for (int i = 1; i < nbtSplitLength; ++i) {
                    sb.append("*").append(nbtSplit[i]);
                }
                nbtString = sb.toString();
            }
            try {
                tag = JsonToNBT.func_180713_a((String)nbtString);
            }
            catch (Exception e) {
                logger.error("[PARSE] Unable to parse nbt string: " + split[1]);
                throw new MalformedRecipeItemException((Throwable)e);
            }
        }
        ParseResult parse = RecipeItemParser.INSTANCE.parse(actualItemString);
        return new NBTParseResult(parse, tag);
    }

    public static void addSubItemsToList(Item item, List<ItemStack> list, DebugFileWrapper debugFileWrapper, boolean debug) {
        NonNullList tempList = NonNullList.func_191196_a();
        item.func_150895_a(CreativeTabs.field_78027_g, tempList);
        for (ItemStack subItem : tempList) {
            ItemStack itemStack = new ItemStack(subItem.func_77973_b(), 1, subItem.func_77960_j());
            list.add(itemStack);
            if (!debug) continue;
            debugFileWrapper.debug("[PARSE] Added itemStack to drop: " + itemStack);
        }
    }

    private ParserUtil() {
    }

    public static void main(String[] args) {
        ILogger logger = new ILogger(){

            @Override
            public void warn(String message) {
                System.out.println(message);
            }

            @Override
            public void error(String message) {
                System.out.println(message);
            }

            @Override
            public void error(String message, Throwable error) {
                System.out.println(message);
                System.out.println(error.getMessage());
                error.printStackTrace();
            }
        };
        String[] test = new String[]{"minecraft:cobblestone:0#{display:{Name:\"Never * 73     # ** blah\"}}   *    42  ", "minecraft:cobblestone:0#{display:{Name:\"Never * 73     # ** blah\"}} * 42", "minecraft:cobblestone:0   *    42  ", "minecraft:cobblestone:0 * 42"};
        for (int i = 0; i < test.length; i += 2) {
            String s = test[i];
            try {
                NBTParseResult result = ParserUtil.parseWithNBT(s, logger);
                if (result.toString().equals(test[i + 1])) continue;
                System.out.println(result + " != " + test[i + 1]);
                continue;
            }
            catch (MalformedRecipeItemException e) {
                e.printStackTrace();
                break;
            }
        }
    }

    public static class NBTParseResult {
        private final ParseResult parseResult;
        private final NBTTagCompound tag;

        public NBTParseResult(ParseResult parseResult, @Nullable NBTTagCompound tag) {
            this.parseResult = parseResult;
            this.tag = tag;
        }

        @Nullable
        public NBTTagCompound getTag() {
            return this.tag;
        }

        public String getDomain() {
            return this.parseResult.getDomain();
        }

        public String getPath() {
            return this.parseResult.getPath();
        }

        public int getMeta() {
            return this.parseResult.getMeta();
        }

        public int getQuantity() {
            return this.parseResult.getQuantity();
        }

        public String toString() {
            return this.getDomain() + ":" + this.getPath() + ":" + this.getMeta() + (this.tag != null ? "#" + this.tag : "") + " * " + this.getQuantity();
        }
    }
}

