/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.dropt.modules.dropt.command;

import com.codetaylor.mc.dropt.modules.dropt.ModuleDropt;
import com.codetaylor.mc.dropt.modules.dropt.Util;
import com.codetaylor.mc.dropt.modules.dropt.rule.RuleLoader;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.RuleList;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.DebugFileWrapper;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.LoggerWrapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.logging.log4j.Logger;

public class Command
extends CommandBase {
    public String func_71517_b() {
        return "dropt";
    }

    public String func_71518_a(ICommandSender sender) {
        return "dropt <reload>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length > 0) {
            if ("export".equals(args[0])) {
                long timestamp = System.currentTimeMillis();
                sender.func_145747_a((ITextComponent)new TextComponentString("Exporting to config/dropt/export/" + timestamp));
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                Path exportPath = ModuleDropt.RULE_PATH.resolve("export/" + timestamp);
                try {
                    Files.deleteIfExists(exportPath);
                }
                catch (IOException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Error exporting, see log for details"));
                    ModuleDropt.LOGGER.error("Unable to delete export folder", (Throwable)e);
                    return;
                }
                try {
                    Files.createDirectories(exportPath, new FileAttribute[0]);
                }
                catch (IOException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Error exporting, see log for details"));
                    ModuleDropt.LOGGER.error("Unable to create export folder", (Throwable)e);
                    return;
                }
                if (!Files.isDirectory(exportPath, new LinkOption[0])) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Error exporting, see log for details"));
                    ModuleDropt.LOGGER.error("Export path not a folder: " + exportPath.toString());
                    return;
                }
                int[] illegalChars = new int[]{34, 60, 62, 124, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 58, 42, 63, 92, 47};
                Arrays.sort(illegalChars);
                for (RuleList list : ModuleDropt.RULE_LISTS) {
                    StringBuilder cleanName = new StringBuilder();
                    int len = list._filename.codePointCount(0, list._filename.length());
                    for (int i = 0; i < len; ++i) {
                        int c = list._filename.codePointAt(i);
                        if (Arrays.binarySearch(illegalChars, c) < 0) {
                            cleanName.appendCodePoint(c);
                            continue;
                        }
                        cleanName.append("_");
                    }
                    String filename = cleanName.toString().replaceAll(":", "_");
                    Path ruleFile = exportPath.resolve(filename + ".json");
                    try {
                        FileWriter writer = new FileWriter(ruleFile.toFile());
                        gson.toJson((Object)list, (Appendable)writer);
                        writer.close();
                        sender.func_145747_a((ITextComponent)new TextComponentString("Exported " + filename));
                    }
                    catch (IOException e) {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Error exporting, see log for details"));
                        ModuleDropt.LOGGER.error("Error exporting rule list: " + filename, (Throwable)e);
                    }
                }
            } else if ("reload".equals(args[0])) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Starting rule list reload..."));
                FileWriter logFileWriter = ModuleDropt.LOG_FILE_WRITER_PROVIDER.createLogFileWriter();
                CommandLoggerWrapper wrapper = new CommandLoggerWrapper(ModuleDropt.LOGGER, sender, logFileWriter);
                ModuleDropt.RULE_LISTS.clear();
                ModuleDropt.RULE_CACHE.clear();
                RuleLoader.loadRuleLists(ModuleDropt.RULE_PATH, ModuleDropt.RULE_LISTS, wrapper, new DebugFileWrapper(logFileWriter));
                RuleLoader.parseRuleLists(ModuleDropt.RULE_LISTS, wrapper, new DebugFileWrapper(logFileWriter));
                Util.closeSilently(logFileWriter);
                sender.func_145747_a((ITextComponent)new TextComponentString("[" + ModuleDropt.RULE_LISTS.size() + "] files processed"));
            } else if ("hand".equals(args[0])) {
                ItemStack itemStack;
                ResourceLocation registryName;
                if (sender instanceof EntityPlayer && (registryName = (itemStack = ((EntityPlayer)sender).func_184614_ca()).func_77973_b().getRegistryName()) != null) {
                    String string = registryName.toString() + ":" + itemStack.func_77960_j();
                    NBTTagCompound tagCompound = itemStack.func_77978_p();
                    if (tagCompound != null) {
                        string = string + "#" + tagCompound.toString();
                    }
                    string = string.replaceAll("\"", "\\\\\"");
                    sender.func_145747_a((ITextComponent)new TextComponentString(string));
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
                }
            } else if ("verbose".equals(args[0]) && sender instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)sender;
                if (ModuleDropt.CONSOLE_LOG.hasListeningPlayer(player)) {
                    ModuleDropt.CONSOLE_LOG.removeListeningPlayer(player);
                    sender.func_145747_a((ITextComponent)new TextComponentString("verbose off"));
                } else {
                    ModuleDropt.CONSOLE_LOG.addListeningPlayer(player);
                    sender.func_145747_a((ITextComponent)new TextComponentString("verbose on - logging block info to console"));
                }
            }
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            return server.func_184103_al().func_152596_g(((EntityPlayer)sender).func_146103_bH());
        }
        return false;
    }

    private static class CommandLoggerWrapper
    extends LoggerWrapper {
        private final ICommandSender sender;

        public CommandLoggerWrapper(Logger logger, ICommandSender sender, FileWriter fileWriter) {
            super(logger, fileWriter);
            this.sender = sender;
        }

        @Override
        public void warn(String message) {
            super.warn(message);
            this.sender.func_145747_a((ITextComponent)new TextComponentString(message));
        }

        @Override
        public void error(String message) {
            super.error(message);
            this.sender.func_145747_a((ITextComponent)new TextComponentString(message));
        }

        @Override
        public void error(String message, Throwable error) {
            super.error(message, error);
            this.sender.func_145747_a((ITextComponent)new TextComponentString(message));
            this.sender.func_145747_a((ITextComponent)new TextComponentString(error.getMessage()));
        }
    }
}

