/*
 * Decompiled with CFR 0.152.
 */
package caracalsmod.entity;

import caracalsmod.WTFConfig;
import caracalsmod.client.CaracalSoundEvents;
import caracalsmod.entity.EntityAICaracalSit;
import caracalsmod.entity.EntityAIOwnerNearTarget;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIOcelotAttack;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeBeach;
import net.minecraft.world.biome.BiomeStoneBeach;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityCaracal
extends EntityTameable {
    private EntityAIAvoidEntity<EntityPlayer> avoidEntity;
    private EntityAITempt aiTempt;
    private int earFlopLeftTime = 0;
    private int earFlopRightTime = 0;
    private static final DataParameter<Boolean> IS_BLUE = EntityDataManager.func_187226_a(EntityCaracal.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_FLOPPING_RIGHT = EntityDataManager.func_187226_a(EntityCaracal.class, (DataSerializer)DataSerializers.field_187198_h);
    public static Biome[] COMMON_BIOMES;
    public static Biome[] RARE_BIOMES;
    public static final float BIOME_AVG_TEMP = 1.05f;
    public static final float BIOME_AVG_RAIN = 0.3f;
    public static final float COMMON_TEMP_RAIN_RADIUS = 0.4f;
    public static final float RARE_TEMP_RAIN_RADIUS = 0.55f;
    public static Set<Item> TAME_ITEMS;

    public static void initBiomes() {
        ArrayList<Biome> commonBiomes = new ArrayList<Biome>();
        ArrayList<Biome> rareBiomes = new ArrayList<Biome>();
        for (Biome biome : Biome.field_185377_q) {
            if (biome instanceof BiomeBeach || biome instanceof BiomeStoneBeach) continue;
            float defaultTemp = biome.func_185353_n();
            float defaultRain = biome.func_76727_i();
            float variance = (float)Math.sqrt(Math.pow(1.05f - defaultTemp, 2.0) + Math.pow(0.3f - defaultRain, 2.0)) - 0.01f;
            if (0.4f < variance && variance <= 0.55f) {
                rareBiomes.add(biome);
                continue;
            }
            if (!(variance <= 0.4f)) continue;
            commonBiomes.add(biome);
        }
        COMMON_BIOMES = commonBiomes.toArray(new Biome[0]);
        RARE_BIOMES = rareBiomes.toArray(new Biome[0]);
    }

    public EntityCaracal(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 0.7f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_BLUE, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(IS_FLOPPING_RIGHT, (Object)Boolean.FALSE);
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.aiTempt = new EntityAITempt((EntityCreature)this, 0.6, true, TAME_ITEMS);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.3f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIOcelotAttack((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiTempt);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 5.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAICaracalSit(this, 0.8));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 0.8));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8, 1.0000001E-5f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAIOwnerNearTarget(this, 10.0f));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntityChicken.class, false, null));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(100) == 0 && this.earFlopLeftTime == 0) {
                this.earFlopLeftTime = 8;
            }
            if (this.field_70146_Z.nextInt(100) == 0 && this.earFlopRightTime == 0) {
                this.earFlopRightTime = 8;
            }
            if (this.earFlopLeftTime > 0) {
                --this.earFlopLeftTime;
            }
            if (this.earFlopRightTime > 0) {
                --this.earFlopRightTime;
            }
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70170_p.func_72820_D() % 300L == 0L) {
            this.func_70691_i(0.5f);
        }
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        if (this.func_70909_n()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
        }
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(WTFConfig.caracalAttackDamage);
    }

    public float getEarFlopAngle(float partialTicks, boolean isLeft) {
        int timer;
        int n = timer = isLeft ? this.earFlopLeftTime : this.earFlopRightTime;
        if (timer == 0) {
            return 0.0f;
        }
        double realTimer = ((double)timer - (double)partialTicks) * 0.39269908169872414;
        return (float)Math.pow(Math.sin(realTimer), 3.0);
    }

    public EntityCaracal createChild(EntityAgeable ageable) {
        EntityCaracal caracal = new EntityCaracal(this.field_70170_p);
        if (this.func_70909_n()) {
            caracal.func_184754_b(this.func_184753_b());
            caracal.func_70903_f(true);
            caracal.setIsBlue(this.isBlue());
        }
        return caracal;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("isBlue", this.isBlue());
        compound.func_74757_a("isFloppingRight", this.isFloppingRight());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setIsBlue(compound.func_74767_n("isBlue"));
        this.setIsFloppingRight(compound.func_74767_n("isFloppingRight"));
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (this.field_70165_t * this.field_70163_u % 500.0 == 17.0) {
            this.setIsBlue(true);
        }
        return livingdata;
    }

    public boolean isBlue() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_BLUE);
    }

    public void setIsBlue(boolean isBlue) {
        this.field_70180_af.func_187227_b(IS_BLUE, (Object)isBlue);
    }

    public boolean isFloppingRight() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_FLOPPING_RIGHT);
    }

    public void setIsFloppingRight(boolean isFloppingRight) {
        this.field_70180_af.func_187227_b(IS_FLOPPING_RIGHT, (Object)isFloppingRight);
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(otherAnimal instanceof EntityCaracal)) {
            return false;
        }
        EntityCaracal caracal = (EntityCaracal)otherAnimal;
        if (!caracal.func_70909_n()) {
            return false;
        }
        return this.func_70880_s() && caracal.func_70880_s();
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return this.func_70909_n() ? I18n.func_74838_a((String)"entity.tamed_caracal.name") : super.func_70005_c_();
    }

    protected void func_175544_ck() {
        if (this.avoidEntity == null) {
            this.avoidEntity = new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 16.0f, 0.8, 1.33);
        }
        this.field_70714_bg.func_85156_a(this.avoidEntity);
        if (!this.func_70909_n()) {
            this.field_70714_bg.func_75776_a(4, this.avoidEntity);
        }
    }

    public void func_70619_bc() {
        if (this.func_70605_aq().func_75640_a()) {
            double d0 = this.func_70605_aq().func_75638_b();
            if (d0 == 0.6) {
                this.func_70095_a(true);
                this.func_70031_b(false);
            } else if (d0 == 1.33) {
                this.func_70095_a(false);
                this.func_70031_b(true);
            } else {
                this.func_70095_a(false);
                this.func_70031_b(false);
            }
        } else {
            this.func_70095_a(false);
            this.func_70031_b(false);
        }
    }

    protected boolean func_70692_ba() {
        return !this.func_70909_n() && this.field_70173_aa > 2400;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.func_70909_n()) {
            if (this.func_70880_s()) {
                return CaracalSoundEvents.CARACAL_PURR;
            }
            if (this.func_70638_az() != null) {
                return this.field_70146_Z.nextInt(4) == 0 ? CaracalSoundEvents.CARACAL_HISS : CaracalSoundEvents.CARACAL_GROWL;
            }
            return this.field_70146_Z.nextInt(4) == 0 ? CaracalSoundEvents.CARACAL_PURR : CaracalSoundEvents.CARACAL_MEOW;
        }
        return this.field_70146_Z.nextInt(4) == 0 ? CaracalSoundEvents.CARACAL_MEOW : null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.field_70146_Z.nextInt(4) == 0 ? CaracalSoundEvents.CARACAL_HISS : CaracalSoundEvents.CARACAL_GROWL;
    }

    protected SoundEvent func_184615_bR() {
        return CaracalSoundEvents.CARACAL_HISS;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public boolean func_70652_k(Entity entityIn) {
        return entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 3.0f);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        EntityLivingBase living;
        Entity entity;
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!WTFConfig.friendlyFire && this.func_70909_n() && source.func_76346_g() != null && (entity = source.func_76346_g()) instanceof EntityLivingBase && (this.func_152114_e(living = (EntityLivingBase)entity) || this.func_70902_q() != null && living.func_184191_r((Entity)this.func_70902_q()))) {
            return false;
        }
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.func_70909_n()) {
            if (this.func_152114_e((EntityLivingBase)player)) {
                if (!this.func_70877_b(itemstack)) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70911_d.func_75270_a(!this.func_70906_o());
                        this.setIsFloppingRight(this.field_70170_p.field_73012_v.nextBoolean());
                    }
                } else {
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_70691_i(2.0f);
                    }
                }
            }
        } else if ((this.aiTempt == null || !this.aiTempt.func_75277_f()) && TAME_ITEMS.contains(itemstack.func_77973_b()) && player.func_70068_e((Entity)this) < 9.0) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((EntityAnimal)this, (EntityPlayer)player)) {
                    this.func_193101_c(player);
                    this.func_70908_e(true);
                    this.field_70911_d.func_75270_a(true);
                    this.setIsFloppingRight(this.field_70170_p.field_73012_v.nextBoolean());
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70877_b(ItemStack stack) {
        return TAME_ITEMS.contains(stack.func_77973_b());
    }

    static {
        TAME_ITEMS = new ObjectOpenHashSet((Object[])new Item[]{Items.field_151115_aP, Items.field_151076_bf, Items.field_179558_bo});
    }
}

