/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.bdsandm.items;

import funwayguy.bdsandm.blocks.tiles.TileEntityBarrel;
import funwayguy.bdsandm.client.color.IBdsmColorItem;
import funwayguy.bdsandm.inventory.capability.BdsmCapabilies;
import funwayguy.bdsandm.inventory.capability.CapabilityBarrel;
import funwayguy.bdsandm.inventory.capability.CapabilityProviderBarrel;
import funwayguy.bdsandm.inventory.capability.IBarrel;
import funwayguy.bdsandm.inventory.capability.IStackContainer;
import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBarrel
extends ItemBlock
implements IBdsmColorItem {
    private final int stackCap;
    private final int maxCap;
    private static final DecimalFormat df = new DecimalFormat("0.##");
    private static final String[] suffixes = new String[]{"", "K", "M", "B", "T"};

    public ItemBarrel(Block block, int initCap, int maxCap) {
        super(block);
        this.stackCap = initCap;
        this.maxCap = maxCap;
    }

    @Override
    public int getColorCount(ItemStack stack) {
        if (!stack.hasCapability(BdsmCapabilies.BARREL_CAP, null)) {
            return 0;
        }
        return ((IBarrel)stack.getCapability(BdsmCapabilies.BARREL_CAP, null)).getColorCount();
    }

    @Override
    public int[] getColors(ItemStack stack) {
        if (!stack.hasCapability(BdsmCapabilies.BARREL_CAP, null)) {
            return new int[0];
        }
        return ((IBarrel)stack.getCapability(BdsmCapabilies.BARREL_CAP, null)).getColors();
    }

    @Override
    public void setColors(ItemStack stack, int[] color) {
        if (!stack.hasCapability(BdsmCapabilies.BARREL_CAP, null)) {
            return;
        }
        ((IBarrel)stack.getCapability(BdsmCapabilies.BARREL_CAP, null)).setColors(color);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        CapabilityProviderBarrel capBarrel = new CapabilityProviderBarrel(this.stackCap, this.maxCap).setParentStack(stack);
        if (nbt != null) {
            capBarrel.deserializeNBT(nbt);
        }
        return capBarrel;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        CapabilityBarrel barrel = (CapabilityBarrel)stack.getCapability(BdsmCapabilies.BARREL_CAP, null);
        assert (barrel != null);
        if (!barrel.getRefItem().func_190926_b()) {
            tooltip.add("Item: " + barrel.getRefItem().func_82833_r());
            tooltip.add("Amount: " + ItemBarrel.formatValue(barrel.getCount()));
        } else if (barrel.getRefFluid() != null) {
            tooltip.add("Fluid: " + barrel.getRefFluid().getLocalizedName());
            tooltip.add("Amount: " + ItemBarrel.formatValue(barrel.getCount()) + " mB");
        } else if (stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("barrelCap", 10)) {
            tooltip.add("[EMPTY]");
        }
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        CapabilityBarrel barrel = (CapabilityBarrel)stack.getCapability(BdsmCapabilies.BARREL_CAP, null);
        assert (barrel != null);
        stack.func_77983_a("barrelCap", (NBTBase)barrel.serializeNBT());
        return super.getNBTShareTag(stack);
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        super.readNBTShareTag(stack, nbt);
        CapabilityBarrel barrel = (CapabilityBarrel)stack.getCapability(BdsmCapabilies.BARREL_CAP, null);
        assert (barrel != null);
        barrel.deserializeNBT(stack.func_190925_c("barrelCap"));
    }

    public boolean placeBlockAt(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, World world, @Nonnull BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull IBlockState newState) {
        if (!super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState)) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBarrel && tile.hasCapability(BdsmCapabilies.BARREL_CAP, null)) {
            ((IBarrel)tile.getCapability(BdsmCapabilies.BARREL_CAP, null)).copyContainer((IStackContainer)stack.getCapability(BdsmCapabilies.BARREL_CAP, null));
            ((TileEntityBarrel)tile).onCrateChanged();
        }
        return true;
    }

    private static String formatValue(long value) {
        String s = "";
        double n = 1.0;
        for (int i = suffixes.length - 1; i >= 0; --i) {
            n = Math.pow(1000.0, i);
            if (!((double)Math.abs(value) >= n)) continue;
            s = suffixes[i];
            break;
        }
        return df.format((double)value / n) + s;
    }
}

