/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.bdsandm.inventory.capability;

import funwayguy.bdsandm.core.BDSM;
import funwayguy.bdsandm.core.BdsmConfig;
import funwayguy.bdsandm.inventory.capability.ICrate;
import funwayguy.bdsandm.inventory.capability.ICrateCallback;
import funwayguy.bdsandm.inventory.capability.IStackContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;

public class CapabilityCrate
implements ICrate {
    private ItemStack refStack = ItemStack.field_190927_a;
    private final List<OreIngredient> cachedOres = new ArrayList<OreIngredient>();
    private int maxStackCapacity;
    private boolean oreDict = false;
    private boolean lock = false;
    private boolean overflow = false;
    private int[] colors = new int[]{-1, -1};
    private int stackCapacity;
    private int count = 0;
    private ICrateCallback callback;
    private ItemStack slotRef = ItemStack.field_190927_a;

    public CapabilityCrate(int initCap, int maxStackCap) {
        this.stackCapacity = initCap;
        this.maxStackCapacity = maxStackCap;
    }

    @Override
    public int getColorCount() {
        return this.colors.length;
    }

    @Override
    public int[] getColors() {
        return this.colors;
    }

    @Override
    public void setColors(int[] c) {
        for (int i = 0; i < c.length && i < this.colors.length; ++i) {
            this.colors[i] = c[i];
        }
    }

    @Override
    @Nonnull
    public ItemStack getRefItem() {
        return this.refStack;
    }

    @Override
    public boolean isLocked() {
        return this.lock;
    }

    @Override
    public void setLocked(boolean state) {
        this.lock = state;
    }

    @Override
    public boolean voidOverflow() {
        return this.overflow;
    }

    @Override
    public void setVoidOverflow(boolean state) {
        this.overflow = state;
    }

    @Override
    public boolean canMergeWith(ItemStack stack) {
        if (ItemStack.func_77970_a((ItemStack)this.refStack, (ItemStack)stack)) {
            if (ItemStack.func_179545_c((ItemStack)this.refStack, (ItemStack)stack)) {
                return true;
            }
            if (this.oreDict) {
                for (OreIngredient ing : this.cachedOres) {
                    if (!ing.apply(stack)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public CapabilityCrate setCallback(ICrateCallback callback) {
        this.callback = callback;
        return this;
    }

    @Override
    public void syncContainer() {
        if (this.callback != null) {
            this.callback.onCrateChanged();
        }
        if (this.refStack.func_190926_b()) {
            this.slotRef = ItemStack.field_190927_a;
        } else if (!this.slotRef.func_190926_b() && this.canMergeWith(this.slotRef)) {
            this.slotRef.func_190920_e(this.getCount());
        } else {
            this.slotRef = this.refStack.func_77946_l();
            this.slotRef.func_190920_e(this.getCount());
        }
    }

    @Override
    public int getStackCap() {
        return this.stackCapacity;
    }

    @Override
    public int getUpgradeCap() {
        return this.maxStackCapacity;
    }

    @Override
    public boolean isOreDict() {
        return this.oreDict;
    }

    @Override
    public void enableOreDict(boolean state) {
        this.oreDict = state;
    }

    @Override
    public void setStackCap(int value) {
        this.stackCapacity = value;
    }

    @Override
    public int getCount() {
        return this.stackCapacity < 0 ? 32768 * this.refStack.func_77976_d() : this.count;
    }

    public int getSlots() {
        return 2;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot != 0 || this.refStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return this.slotRef;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot < 0 || slot >= 2 || stack.func_190926_b() || BdsmConfig.isBlacklisted(stack)) {
            return stack;
        }
        if (this.refStack.func_190926_b() || this.stackCapacity < 0 && !this.lock) {
            int used;
            if (this.lock || stack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) || stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) || stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
                return stack;
            }
            if (!simulate) {
                int[] aryIDs;
                this.refStack = stack.func_77946_l();
                this.count = Math.min(stack.func_190916_E(), (this.stackCapacity < 0 ? 32768 : this.stackCapacity) * stack.func_77976_d());
                this.refStack.func_190920_e(1);
                this.cachedOres.clear();
                block0: for (int id : aryIDs = OreDictionary.getOreIDs((ItemStack)this.refStack)) {
                    String name = OreDictionary.getOreName((int)id);
                    for (String bl : BdsmConfig.oreDictBlacklist) {
                        if (!name.matches(bl)) continue;
                        continue block0;
                    }
                    this.cachedOres.add(new OreIngredient(name));
                }
                this.syncContainer();
            }
            if ((used = Math.min(stack.func_190916_E(), (this.stackCapacity < 0 ? 32768 : this.stackCapacity) * stack.func_77976_d())) > stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack rStack = stack.func_77946_l();
            rStack.func_190918_g(used);
            return rStack;
        }
        if (!this.canMergeWith(stack)) {
            return stack;
        }
        long rem = this.stackCapacity < 0 ? 0L : (long)this.stackCapacity * (long)this.refStack.func_77976_d() - (long)this.getCount();
        int add = (int)Math.min(rem, (long)stack.func_190916_E());
        if (add < 0) {
            add = 0;
        }
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(this.overflow ? 0 : stack.func_190916_E() - add);
        if (!simulate && add != 0) {
            this.count += add;
            this.syncContainer();
        }
        return copy;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot != 0 || this.refStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (this.stackCapacity < 0) {
            ItemStack copy = this.refStack.func_77946_l();
            copy.func_190920_e(amount);
            return copy;
        }
        ItemStack copy = this.refStack.func_77946_l();
        copy.func_190920_e(Math.min(amount, this.getCount()));
        if (!simulate) {
            this.count -= copy.func_190916_E();
            if (this.count <= 0 && !this.lock) {
                this.refStack = ItemStack.field_190927_a;
                this.cachedOres.clear();
            }
            this.syncContainer();
        }
        return copy;
    }

    public int getSlotLimit(int slot) {
        return this.overflow ? Integer.MAX_VALUE : (this.refStack.func_190926_b() ? 64 : this.refStack.func_77976_d()) * this.stackCapacity;
    }

    @Override
    public void copyContainer(IStackContainer crate) {
        this.deserializeNBT((NBTTagCompound)crate.serializeNBT());
    }

    @Override
    public boolean installUpgrade(@Nonnull EntityPlayer player, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() == BDSM.itemUpgrade) {
            if (stack.func_77952_i() >= 0 && stack.func_77952_i() < 4) {
                int value = 64 << stack.func_77952_i() * 2;
                int remCap = this.getUpgradeCap() - this.getStackCap();
                if (remCap > 0) {
                    this.setStackCap(this.getStackCap() + Math.min(value, remCap));
                    this.syncContainer();
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                        player.field_71071_by.func_70296_d();
                    }
                    return true;
                }
                return false;
            }
            if (stack.func_77952_i() == 4) {
                if (this.getStackCap() >= 0) {
                    this.setStackCap(-1);
                    this.count = 32768;
                    this.syncContainer();
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                        player.field_71071_by.func_70296_d();
                    }
                    return true;
                }
                return false;
            }
            if (stack.func_77952_i() == 5) {
                if (!this.oreDict) {
                    this.oreDict = true;
                    this.syncContainer();
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                        player.field_71071_by.func_70296_d();
                    }
                    return true;
                }
                return false;
            }
            if (stack.func_77952_i() == 6) {
                if (!this.overflow) {
                    this.overflow = true;
                    this.syncContainer();
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                        player.field_71071_by.func_70296_d();
                    }
                    return true;
                }
                return false;
            }
            if (stack.func_77952_i() == 7) {
                if (this.count <= 0 || this.stackCapacity < 0) {
                    if (!player.field_71075_bZ.field_75098_d && this.getStackCap() > 64) {
                        ItemStack drop;
                        for (int rem = this.getStackCap() - 64; rem >= 64; rem -= 64 << drop.func_77952_i() * 2) {
                            drop = new ItemStack(BDSM.itemUpgrade, 1, 0);
                            if (rem >= 4096) {
                                drop.func_77964_b(3);
                                continue;
                            }
                            if (rem >= 1024) {
                                drop.func_77964_b(2);
                                continue;
                            }
                            if (rem < 256) continue;
                            drop.func_77964_b(1);
                            if (player.func_191521_c(drop)) continue;
                            player.func_146097_a(drop, true, false);
                        }
                    }
                    if (this.stackCapacity < 0) {
                        this.count = 0;
                    }
                    this.setStackCap(64);
                    if (!this.lock) {
                        this.refStack = ItemStack.field_190927_a;
                    }
                }
                if (this.oreDict) {
                    ItemStack drop;
                    if (!player.field_71075_bZ.field_75098_d && !player.func_191521_c(drop = new ItemStack(BDSM.itemUpgrade, 1, 5))) {
                        player.func_146097_a(drop, true, false);
                    }
                    this.oreDict = false;
                }
                if (this.overflow) {
                    ItemStack drop;
                    if (!player.field_71075_bZ.field_75098_d && !player.func_191521_c(drop = new ItemStack(BDSM.itemUpgrade, 1, 6))) {
                        player.func_146097_a(drop, true, false);
                    }
                    this.overflow = false;
                }
                this.syncContainer();
                return true;
            }
        } else if (stack.func_77973_b() == BDSM.itemKey) {
            boolean bl = this.lock = !this.lock;
            if (!this.lock && this.getCount() <= 0) {
                this.refStack = ItemStack.field_190927_a;
                this.cachedOres.clear();
            }
            this.syncContainer();
            return true;
        }
        return false;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("refStack", (NBTBase)this.refStack.func_77955_b(new NBTTagCompound()));
        nbt.func_74768_a("count", this.count);
        nbt.func_74768_a("stackCap", this.stackCapacity);
        nbt.func_74768_a("maxCap", this.maxStackCapacity);
        nbt.func_74757_a("oreDict", this.oreDict);
        nbt.func_74757_a("overflow", this.overflow);
        nbt.func_74757_a("locked", this.lock);
        nbt.func_74783_a("objColors", this.colors);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.refStack = new ItemStack(nbt.func_74775_l("refStack"));
        this.count = nbt.func_74762_e("count");
        this.stackCapacity = nbt.func_74762_e("stackCap");
        this.maxStackCapacity = nbt.func_74762_e("maxCap");
        this.oreDict = nbt.func_74767_n("oreDict");
        this.overflow = nbt.func_74767_n("overflow");
        this.lock = nbt.func_74767_n("locked");
        this.colors = Arrays.copyOf(nbt.func_74759_k("objColors"), this.colors.length);
        if (!this.refStack.func_190926_b()) {
            int[] aryIDs;
            this.cachedOres.clear();
            block0: for (int id : aryIDs = OreDictionary.getOreIDs((ItemStack)this.refStack)) {
                String name = OreDictionary.getOreName((int)id);
                for (String bl : BdsmConfig.oreDictBlacklist) {
                    if (!name.matches(bl)) continue;
                    continue block0;
                }
                this.cachedOres.add(new OreIngredient(name));
            }
            if (!this.slotRef.func_190926_b() && this.canMergeWith(this.slotRef)) {
                this.slotRef.func_190920_e(this.getCount());
            } else {
                this.slotRef = this.refStack.func_77946_l();
                this.slotRef.func_190920_e(this.getCount());
            }
        } else {
            this.slotRef = ItemStack.field_190927_a;
        }
    }
}

