/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.bdsandm.client.obj;

import funwayguy.bdsandm.client.obj.OBJModelColored;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.io.IOUtils;

public class OBJLoaderColored
implements ICustomModelLoader {
    public static final OBJLoaderColored INSTANCE = new OBJLoaderColored();
    private IResourceManager manager;
    private final Set<String> enabledDomains = new HashSet<String>();
    private final Map<ResourceLocation, OBJModelColored> cache = new HashMap<ResourceLocation, OBJModelColored>();
    private final Map<ResourceLocation, Exception> errors = new HashMap<ResourceLocation, Exception>();

    public void addDomain(String domain) {
        this.enabledDomains.add(domain.toLowerCase());
        FMLLog.log.info("OBJLoaderColored: Domain {} has been added.", (Object)domain.toLowerCase());
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.manager = resourceManager;
        this.cache.clear();
        this.errors.clear();
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return this.enabledDomains.contains(modelLocation.func_110624_b()) && modelLocation.func_110623_a().endsWith(".obj");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        OBJModelColored model;
        ResourceLocation file = new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a());
        if (!this.cache.containsKey(file)) {
            IResource resource = null;
            try {
                try {
                    resource = this.manager.func_110536_a(file);
                }
                catch (FileNotFoundException e) {
                    if (modelLocation.func_110623_a().startsWith("models/block/")) {
                        resource = this.manager.func_110536_a(new ResourceLocation(file.func_110624_b(), "models/item/" + file.func_110623_a().substring("models/block/".length())));
                    }
                    if (modelLocation.func_110623_a().startsWith("models/item/")) {
                        resource = this.manager.func_110536_a(new ResourceLocation(file.func_110624_b(), "models/block/" + file.func_110623_a().substring("models/item/".length())));
                    }
                    throw e;
                }
                OBJModelColored.Parser parser = new OBJModelColored.Parser(resource, this.manager);
                OBJModelColored model2 = null;
                try {
                    model2 = parser.parse();
                }
                catch (Exception e) {
                    this.errors.put(modelLocation, e);
                }
                finally {
                    this.cache.put(modelLocation, model2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resource);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)resource);
        }
        if ((model = this.cache.get(file)) == null) {
            throw new ModelLoaderRegistry.LoaderException("Error loading model previously: " + file, (Throwable)this.errors.get(modelLocation));
        }
        return model;
    }
}

