/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.bdsandm.blocks;

import funwayguy.bdsandm.blocks.IStorageBlock;
import funwayguy.bdsandm.blocks.tiles.TileEntityCrate;
import funwayguy.bdsandm.core.BDSM;
import funwayguy.bdsandm.inventory.capability.BdsmCapabilies;
import funwayguy.bdsandm.inventory.capability.ICrate;
import funwayguy.bdsandm.inventory.capability.IStackContainer;
import funwayguy.bdsandm.network.PacketBdsm;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockCrateBase
extends BlockDirectional
implements ITileEntityProvider,
IStorageBlock {
    private final int initCap;
    private final int maxCap;

    public BlockCrateBase(Material material, int initCap, int maxCap) {
        super(material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(BDSM.tabBdsm);
        this.initCap = initCap;
        this.maxCap = maxCap;
    }

    @Override
    public void onPlayerInteract(World world, BlockPos pos, IBlockState state, EnumFacing side, EntityPlayerMP player, EnumHand hand, boolean isHit, boolean altMode, int clickDelay) {
        int curClick;
        EnumFacing curFace = (EnumFacing)state.func_177229_b((IProperty)field_176387_N);
        if (curFace != side.func_176734_d()) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntityCrate)) {
            return;
        }
        TileEntityCrate tileCrate = (TileEntityCrate)tile;
        ICrate crate = (ICrate)tile.getCapability(BdsmCapabilies.CRATE_CAP, null);
        if (crate == null || !isHit && crate.installUpgrade((EntityPlayer)player, player.func_184586_b(hand))) {
            return;
        }
        if (!isHit) {
            if (!player.func_70093_af()) {
                this.depositItem(crate, (EntityPlayer)player, hand);
            }
        } else if (altMode) {
            this.withdrawItem(crate, (EntityPlayer)player, player.func_70093_af() ? 0 : 2);
        } else if (!player.func_70093_af() && (curClick = tileCrate.getClickCount(world.func_82737_E(), clickDelay)) >= 0) {
            this.withdrawItem(crate, (EntityPlayer)player, curClick);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K || !(playerIn instanceof EntityPlayerMP)) {
            return true;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("msgType", 2);
        tag.func_74772_a("pos", pos.func_177986_g());
        tag.func_74757_a("isHit", false);
        tag.func_74757_a("offHand", hand == EnumHand.OFF_HAND);
        BDSM.INSTANCE.network.sendTo((IMessage)new PacketBdsm(tag), (EntityPlayerMP)playerIn);
        return true;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        if (worldIn.field_72995_K || !(playerIn instanceof EntityPlayerMP)) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("msgType", 2);
        tag.func_74772_a("pos", pos.func_177986_g());
        tag.func_74757_a("isHit", true);
        tag.func_74757_a("offHand", false);
        BDSM.INSTANCE.network.sendTo((IMessage)new PacketBdsm(tag), (EntityPlayerMP)playerIn);
    }

    private void depositItem(ICrate crate, EntityPlayer player, EnumHand hand) {
        block6: {
            ItemStack ref;
            block7: {
                ref = crate.getRefItem();
                ItemStack held = player.func_184586_b(hand);
                if (held.func_190926_b() || !ref.func_190926_b() && !crate.canMergeWith(held) && !held.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) break block7;
                if (held.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                    IItemHandler heldCrate = (IItemHandler)held.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                    assert (heldCrate != null);
                    for (int s = 0; s < heldCrate.getSlots(); ++s) {
                        ItemStack transfer = heldCrate.extractItem(s, Integer.MAX_VALUE, true);
                        ItemStack transStack = transfer.func_77946_l();
                        transStack.func_190920_e(transStack.func_190916_E() * held.func_190916_E());
                        int prev = transStack.func_190916_E();
                        if (prev <= 0 || !ref.func_190926_b() && !crate.canMergeWith(transStack) || (transStack = crate.insertItem(crate.getSlots() - 1, transStack, false)).func_190916_E() == prev) continue;
                        heldCrate.extractItem(s, (prev - transStack.func_190916_E()) / held.func_190916_E(), false);
                    }
                } else {
                    player.func_184611_a(hand, crate.insertItem(crate.getSlots() - 1, held, false));
                }
                break block6;
            }
            if (ref.func_190926_b()) break block6;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack invoStack = player.field_71071_by.func_70301_a(i);
                if (!crate.canMergeWith(invoStack)) continue;
                invoStack = crate.insertItem(crate.getSlots() - 1, invoStack, false);
                boolean done = !invoStack.func_190926_b();
                player.field_71071_by.func_70299_a(i, invoStack);
                if (!done) {
                    continue;
                }
                break;
            }
        }
    }

    private void withdrawItem(ICrate crate, EntityPlayer player, int clickCount) {
        if (!crate.getRefItem().func_190926_b()) {
            int count;
            int n = count = clickCount <= 0 ? 1 : crate.getRefItem().func_77976_d();
            if (clickCount == 1) {
                --count;
            }
            ItemStack out = crate.extractItem(0, count, false);
            if (player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
                player.func_184611_a(EnumHand.MAIN_HAND, out);
            } else if (!player.func_191521_c(out)) {
                player.func_146097_a(out, false, false);
            }
        }
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nullable
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TileEntityCrate(this.initCap, this.maxCap);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityCrate) {
            ((TileEntityCrate)tile).onCrateChanged();
        }
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, @Nonnull EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer).func_176734_d());
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176745_a();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.func_82600_a((int)(meta & 7)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176387_N});
    }

    public void func_180653_a(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, float chance, int fortune) {
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityCrate) {
            ((TileEntityCrate)tile).setCreativeBroken(player.field_71075_bZ.field_75098_d);
        }
    }

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityCrate && !((TileEntityCrate)tileentity).isCreativeBroken()) {
            TileEntityCrate tileBarrel = (TileEntityCrate)tileentity;
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this));
            ICrate tileCap = tileBarrel.getCapability(BdsmCapabilies.CRATE_CAP, null);
            ICrate itemCap = (ICrate)stack.getCapability(BdsmCapabilies.CRATE_CAP, null);
            assert (itemCap != null);
            itemCap.copyContainer(tileCap);
            BlockCrateBase.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Nonnull
    public ItemStack func_185473_a(World worldIn, BlockPos pos, @Nonnull IBlockState state) {
        ItemStack stack = super.func_185473_a(worldIn, pos, state);
        TileEntity tileBarrel = worldIn.func_175625_s(pos);
        if (tileBarrel instanceof TileEntityCrate) {
            ICrate tileCap = (ICrate)tileBarrel.getCapability(BdsmCapabilies.CRATE_CAP, null);
            ICrate itemCap = (ICrate)stack.getCapability(BdsmCapabilies.CRATE_CAP, null);
            assert (itemCap != null);
            itemCap.copyContainer(tileCap);
        }
        return stack;
    }

    @Nonnull
    public IBlockState func_185499_a(@Nonnull IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_176387_N, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    @Nonnull
    public IBlockState func_185471_a(@Nonnull IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    public boolean rotateBlock(World world, @Nonnull BlockPos pos, @Nonnull EnumFacing axis) {
        if (world.field_72995_K) {
            return super.rotateBlock(world, pos, axis);
        }
        TileEntity tile = world.func_175625_s(pos);
        boolean changed = super.rotateBlock(world, pos, axis);
        TileEntity nTile = world.func_175625_s(pos);
        if (changed && tile instanceof TileEntityCrate && nTile instanceof TileEntityCrate) {
            ((ICrate)nTile.getCapability(BdsmCapabilies.CRATE_CAP, null)).copyContainer((IStackContainer)tile.getCapability(BdsmCapabilies.CRATE_CAP, null));
            ((TileEntityCrate)nTile).onCrateChanged();
        }
        return changed;
    }

    @Deprecated
    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    @Deprecated
    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tileBarrel = worldIn.func_175625_s(pos);
        if (tileBarrel instanceof TileEntityCrate) {
            ICrate tileCap = (ICrate)tileBarrel.getCapability(BdsmCapabilies.CRATE_CAP, null);
            assert (tileCap != null);
            long max = tileCap.getStackCap() < 0 ? 32768L : (long)tileCap.getStackCap();
            double fill = (double)tileCap.getCount() / (double)(max *= (long)tileCap.getRefItem().func_77976_d());
            return MathHelper.func_76128_c((double)(fill * 14.0)) + (tileCap.getCount() > 0 ? 1 : 0);
        }
        return 0;
    }

    public boolean canCreatureSpawn(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return true;
    }
}

