/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network.client;

import com.tiviacz.travelersbackpack.client.ClientActions;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ParticlesPacket
implements IMessage {
    private byte particleID;
    private int entityID;

    public ParticlesPacket() {
    }

    public ParticlesPacket(byte particleID, int entityID) {
        this.particleID = particleID;
        this.entityID = entityID;
    }

    public void fromBytes(ByteBuf buf) {
        this.particleID = buf.readByte();
        this.entityID = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte((int)this.particleID);
        buf.writeInt(this.entityID);
    }

    public static class Handler
    implements IMessageHandler<ParticlesPacket, IMessage> {
        public static final byte NYAN_PARTICLE = 0;
        public static final byte SLIME_PARTICLE = 1;
        public static final byte EMERALD_PARTICLE = 2;

        public IMessage onMessage(ParticlesPacket message, MessageContext ctx) {
            if (ctx.side.isClient()) {
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_152344_a(() -> {
                    if (mc.field_71439_g != null) {
                        Entity entity = mc.field_71441_e.func_73045_a(message.entityID);
                        ClientActions.spawnParticlesAtEntity(entity, message.particleID);
                    }
                });
            }
            return null;
        }
    }
}

