/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.handlers;

import net.minecraftforge.common.config.Config;

@Config(modid="travelersbackpack")
public class ConfigHandler {
    public static final Server server = new Server();
    public static final Client client = new Client();

    public static class Client {
        @Config.Comment(value={"Enables auto message with backpack coords after player dies"})
        @Config.Name(value="Backpack Coords Message")
        public boolean enableBackpackCoordsMessage = true;
        @Config.Comment(value={"Enables tool cycling via 'z' (default, check controls) + scroll combination, while backpack is worn"})
        @Config.Name(value="Tool Cycling")
        public boolean enableToolCycling = true;
        @Config.Comment(value={"Enables tip, how to obtain a backpack, if there's no crafting recipe for it"})
        @Config.Name(value="Obtain Tips")
        public boolean obtainTips = true;
        @Config.Comment(value={"Disabling this option may improve performance"})
        @Config.Name(value="Backpack Item Fluid Renderer")
        public boolean enableBackpackItemFluidRenderer = true;
        @Config.Comment(value={"Render tools in tool slots on the backpack, while worn"})
        @Config.Name(value="Render Tools")
        public boolean renderTools = true;
        @Config.Comment(value={"Render backpack while player wears elytra"})
        @Config.Name(value="Render Backpack with Elytra")
        public boolean renderBackpackWithElytra = true;
        @Config.Name(value="Old Gui Tank Render")
        public boolean oldGuiTankRender = false;
        @Config.Name(value="Overlay Position")
        public final Overlay overlay = new Overlay();

        public static class Overlay {
            @Config.Comment(value={"Enables tanks and tool slots overlay, while backpack is worn"})
            @Config.Name(value="Overlay")
            public boolean enableOverlay = true;
            @Config.Comment(value={"Offsets to left side"})
            @Config.Name(value="Offset X")
            public int offsetX = 20;
            @Config.Comment(value={"Offsets to up"})
            @Config.Name(value="Offset Y")
            public int offsetY = 30;
        }
    }

    public static class Server {
        @Config.Comment(value={"Enables warning about modid change"})
        @Config.Name(value="Enable warning")
        public boolean enableWarning = true;
        @Config.Name(value="Backpack's Abilities")
        public boolean enableBackpackAbilities = true;
        @Config.Comment(value={"Places backpack at place where player died"})
        @Config.Name(value="Place Backpack on Death")
        public boolean backpackDeathPlace = true;
        @Config.Name(value="Tool Slots Accept Swords")
        public boolean toolSlotsAcceptSwords = false;
        @Config.Comment(value={"Enables wearing backpack directly from ground"})
        @Config.Name(value="Backpack Block Wearable")
        public boolean enableBackpackBlockWearable = true;
        @Config.Comment(value={"Enables backpacks spawning in loot chests"})
        @Config.Name(value="Loot")
        public boolean enableLoot = true;
        @Config.Comment(value={"Enables button in backpack gui, which allows to empty tank"})
        @Config.Name(value="Empty Tank Button")
        public boolean enableEmptyTankButton = true;
        @Config.Name(value="Sleeping Bag Spawn Point")
        public boolean enableSleepingBagSpawnPoint = false;
        @Config.Name(value="Disable Crafting in Backpack inventory")
        public boolean disableCrafting = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Configures Backpack Tanks Capacity")
        @Config.RangeInt(min=250)
        public int tanksCapacity = 4000;
    }
}

