/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.gui.container;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.gui.container.slots.SlotBackpack;
import com.tiviacz.travelersbackpack.gui.container.slots.SlotDisabled;
import com.tiviacz.travelersbackpack.gui.container.slots.SlotFluid;
import com.tiviacz.travelersbackpack.gui.container.slots.SlotTool;
import com.tiviacz.travelersbackpack.gui.inventory.IInventoryTravelersBackpack;
import com.tiviacz.travelersbackpack.gui.inventory.InventoryCraftingImproved;
import com.tiviacz.travelersbackpack.gui.inventory.InventoryTravelersBackpack;
import com.tiviacz.travelersbackpack.handlers.ConfigHandler;
import com.tiviacz.travelersbackpack.network.client.SyncGuiPacket;
import com.tiviacz.travelersbackpack.tileentity.TileEntityTravelersBackpack;
import com.tiviacz.travelersbackpack.util.EnumSource;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerTravelersBackpack
extends Container {
    public InventoryPlayer playerInv;
    public IInventoryTravelersBackpack inv;
    public InventoryCraftingImproved craftMatrix;
    public InventoryCraftResult craftResult = new InventoryCraftResult();
    public World world;
    public EnumSource source;
    public int[] cachedFields;
    private final int BACKPACK_INV_START = 10;
    private final int BACKPACK_INV_END = 48;
    private final int TOOL_START = 49;
    private final int TOOL_END = 50;
    private final int BUCKET_LEFT_IN = 51;
    private final int BUCKET_LEFT_OUT = 52;
    private final int BUCKET_RIGHT_IN = 53;
    private final int BUCKET_RIGHT_OUT = 54;
    private final int PLAYER_INV_START = 55;
    private final int PLAYER_HOT_END = 90;

    public ContainerTravelersBackpack(World world, InventoryPlayer playerInv, IInventoryTravelersBackpack inventory, EnumSource source) {
        this.world = world;
        this.playerInv = playerInv;
        this.inv = inventory;
        this.source = source;
        this.craftMatrix = new InventoryCraftingImproved(inventory, this, 3, 3);
        int currentItemIndex = playerInv.field_70461_c;
        this.addCraftMatrix();
        this.addCraftResult(playerInv.field_70458_d);
        this.addBackpackInventory(inventory);
        this.addToolSlots(inventory);
        this.addFluidSlots(inventory);
        this.addPlayerInventoryAndHotbar(playerInv, currentItemIndex);
        this.func_75130_a(inventory);
    }

    public void addCraftMatrix() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a(new SlotBackpack((IInventory)this.craftMatrix, j + i * 3, 152 + j * 18, 61 + i * 18));
            }
        }
    }

    public void addCraftResult(EntityPlayer player) {
        this.func_75146_a((Slot)new SlotCrafting(player, (InventoryCrafting)this.craftMatrix, (IInventory)this.craftResult, 0, 226, 97));
    }

    public void addBackpackInventory(IInventoryTravelersBackpack inventory) {
        int j;
        int i;
        int slot = 9;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 8; ++j) {
                this.func_75146_a(new SlotBackpack(inventory, slot++, 62 + j * 18, 7 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 5; ++j) {
                this.func_75146_a(new SlotBackpack(inventory, slot++, 62 + j * 18, 61 + i * 18));
            }
        }
    }

    public void addPlayerInventoryAndHotbar(InventoryPlayer playerInv, int currentItemIndex) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInv, x + y * 9 + 9, 44 + x * 18, 125 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            if (x == currentItemIndex && this.source == EnumSource.ITEM) {
                this.func_75146_a(new SlotDisabled((IInventory)playerInv, x, 44 + x * 18, 183));
                continue;
            }
            this.func_75146_a(new Slot((IInventory)playerInv, x, 44 + x * 18, 183));
        }
    }

    public void addToolSlots(IInventoryTravelersBackpack inventory) {
        this.func_75146_a(new SlotTool(this.playerInv.field_70458_d, this.source, inventory, 48, 44, 79));
        this.func_75146_a(new SlotTool(this.playerInv.field_70458_d, this.source, inventory, 49, 44, 97));
    }

    public void addFluidSlots(IInventoryTravelersBackpack inventory) {
        this.func_75146_a(new SlotFluid(inventory, 50, 6, 7));
        this.func_75146_a(new SlotFluid(inventory, 51, 6, 37));
        this.func_75146_a(new SlotFluid(inventory, 52, 226, 7));
        this.func_75146_a(new SlotFluid(inventory, 53, 226, 37));
    }

    public void func_75142_b() {
        super.func_75142_b();
        InventoryTravelersBackpack itemInv = CapabilityUtils.getBackpackInv(this.playerInv.field_70458_d);
        if (itemInv != null) {
            if (this.cachedFields == null) {
                this.cachedFields = new int[itemInv.func_174890_g()];
                Arrays.fill(this.cachedFields, -1);
            }
            for (IContainerListener listener : this.field_75149_d) {
                for (int i = 0; i < itemInv.func_174890_g(); ++i) {
                    if (this.cachedFields[i] == itemInv.func_174887_a_(i)) continue;
                    this.cachedFields[i] = itemInv.func_174887_a_(i);
                    if (this.cachedFields[i] > Short.MAX_VALUE || this.cachedFields[i] < Short.MIN_VALUE) {
                        TravelersBackpack.NETWORK.sendTo((IMessage)new SyncGuiPacket(i, this.cachedFields[i]), (EntityPlayerMP)listener);
                        continue;
                    }
                    listener.func_71112_a((Container)this, i, this.cachedFields[i]);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        this.inv.func_174885_b(id, data);
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        if (this.source == EnumSource.TILE) {
            TileEntity tile = this.world.func_175625_s(this.inv.getPosition());
            if (tile != null) {
                TileEntityTravelersBackpack backpack = (TileEntityTravelersBackpack)tile;
                return backpack.func_70300_a(playerIn);
            }
            return false;
        }
        return true;
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        Slot slot = this.func_75139_a(index);
        ItemStack result = ItemStack.field_190927_a;
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            result = stack.func_77946_l();
            if (index >= 0 && index <= 54) {
                if (index == 0) {
                    stack.func_77973_b().func_77622_d(stack, this.world, player);
                    if (!this.func_75135_a(stack, 55, 91, true)) {
                        return ItemStack.field_190927_a;
                    }
                    slot.func_75220_a(stack, result);
                    this.craftMatrix.func_70296_d();
                } else if (!this.func_75135_a(stack, 55, 91, true)) {
                    return ItemStack.field_190927_a;
                }
            }
            if (index >= 55) {
                if (SlotTool.isValid(stack) && !this.func_75135_a(stack, 49, 51, false) && !this.func_75135_a(stack, 10, 49, false)) {
                    return ItemStack.field_190927_a;
                }
                if (!this.func_75135_a(stack, 10, 49, false)) {
                    return ItemStack.field_190927_a;
                }
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == result.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stack);
        }
        return result;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (!(this.inv.func_70301_a(50).func_190926_b() && this.inv.func_70301_a(51).func_190926_b() && this.inv.func_70301_a(52).func_190926_b() && this.inv.func_70301_a(53).func_190926_b())) {
            this.world.func_184133_a(playerIn, playerIn.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 1.0f, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
        if (!this.world.field_72995_K) {
            this.clearBucketSlot(playerIn, this.world, this.inv, 50);
            this.clearBucketSlot(playerIn, this.world, this.inv, 52);
            this.clearBucketSlot(playerIn, this.world, this.inv, 51);
            this.clearBucketSlot(playerIn, this.world, this.inv, 53);
        }
    }

    public void func_75130_a(IInventory inventoryIn) {
        if (!ConfigHandler.server.disableCrafting) {
            this.craftResult.func_70299_a(0, CraftingManager.func_82787_a((InventoryCrafting)this.craftMatrix, (World)this.world));
        }
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c != this.craftResult && super.func_94530_a(stack, slotIn);
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (clickTypeIn == ClickType.SWAP) {
            ItemStack stack = player.field_71071_by.func_70301_a(dragType);
            ItemStack currentItem = this.playerInv.func_70448_g();
            if (!currentItem.func_190926_b() && stack == currentItem) {
                return ItemStack.field_190927_a;
            }
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    private void clearBucketSlot(EntityPlayer playerIn, World worldIn, IInventoryTravelersBackpack inventoryIn, int index) {
        if (!playerIn.func_70089_S() || playerIn instanceof EntityPlayerMP && ((EntityPlayerMP)playerIn).func_193105_t()) {
            playerIn.func_71019_a(inventoryIn.func_70304_b(index), false);
        } else {
            playerIn.field_71071_by.func_191975_a(worldIn, inventoryIn.func_70304_b(index));
        }
    }
}

