/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.fluids;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.tiviacz.travelersbackpack.api.fluids.effects.FluidEffect;
import com.tiviacz.travelersbackpack.fluids.effects.EffectLava;
import com.tiviacz.travelersbackpack.fluids.effects.EffectMilk;
import com.tiviacz.travelersbackpack.fluids.effects.EffectPotion;
import com.tiviacz.travelersbackpack.fluids.effects.EffectWater;
import com.tiviacz.travelersbackpack.util.LogHelper;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidEffectRegistry {
    public static BiMap<String, FluidEffect> EFFECT_REGISTRY = HashBiMap.create();
    public static FluidEffect WATER_EFFECT;
    public static FluidEffect LAVA_EFFECT;
    public static FluidEffect MILK_EFFECT;
    public static FluidEffect POTION_EFFECT;
    private static int effectIDCounter;

    public static void initEffects() {
        EFFECT_REGISTRY.clear();
        WATER_EFFECT = new EffectWater();
        LAVA_EFFECT = new EffectLava();
        MILK_EFFECT = new EffectMilk();
        POTION_EFFECT = new EffectPotion();
    }

    public static int registerFluidEffect(FluidEffect effect) {
        String className = effect.getClass().getName();
        if (!EFFECT_REGISTRY.containsKey((Object)className) && effect.fluid != null) {
            EFFECT_REGISTRY.put((Object)className, (Object)effect);
            effect.setEffectID(effectIDCounter);
            LogHelper.info("Registered the class " + className + " as a FluidEffect for " + effect.fluid.getName() + " with the ID " + effectIDCounter, new Object[0]);
            return ++effectIDCounter;
        }
        return -1;
    }

    public static Map<String, FluidEffect> getRegisteredFluidEffects() {
        return ImmutableMap.copyOf(EFFECT_REGISTRY);
    }

    public static String[] getRegisteredFluids() {
        String[] result = new String[EFFECT_REGISTRY.size()];
        int counter = 0;
        for (FluidEffect effect : FluidEffectRegistry.getRegisteredFluidEffects().values()) {
            result[counter++] = effect.fluid.getName();
        }
        return result;
    }

    public static boolean hasFluidEffect(Fluid fluid) {
        for (FluidEffect effect : FluidEffectRegistry.getRegisteredFluidEffects().values()) {
            if (fluid != effect.fluid) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFluidEffectAndCanExecute(FluidStack fluid, World world, Entity entity) {
        for (FluidEffect effect : FluidEffectRegistry.getRegisteredFluidEffects().values()) {
            if (fluid.getFluid() != effect.fluid || !effect.canExecuteEffect(fluid, world, entity)) continue;
            return true;
        }
        return false;
    }

    public static FluidEffect getFluidEffect(Fluid fluid) {
        for (FluidEffect effect : FluidEffectRegistry.getRegisteredFluidEffects().values()) {
            if (fluid != effect.fluid) continue;
            return effect;
        }
        return null;
    }

    public static ArrayList<FluidEffect> getEffectsForFluid(Fluid fluid) {
        ArrayList<FluidEffect> effectsForFluid = new ArrayList<FluidEffect>();
        for (FluidEffect effect : EFFECT_REGISTRY.values()) {
            if (fluid != effect.fluid) continue;
            effectsForFluid.add(effect);
        }
        return effectsForFluid;
    }

    public static boolean executeFluidEffectsForFluid(FluidStack fluid, Entity entity, World world) {
        boolean executed = false;
        for (FluidEffect effect : EFFECT_REGISTRY.values()) {
            if (effect == null || effect.fluid != fluid.getFluid()) continue;
            effect.affectDrinker(fluid, world, entity);
            executed = true;
        }
        return executed;
    }

    static {
        effectIDCounter = 0;
    }
}

