/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.schematics;

import ivorius.ivtoolkit.tools.IvFileHelper;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.utils.accessor.RCAccessorNBT;
import ivorius.reccomplex.world.gen.feature.structure.schematics.SchematicFile;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class SchematicLoader {
    public static void initializeFolder() {
        SchematicLoader.getValidatedSchematicsFile();
    }

    public static SchematicFile loadSchematicByName(String name) throws SchematicFile.UnsupportedSchematicFormatException {
        if (FilenameUtils.getExtension((String)name).length() == 0) {
            name = name + ".schematic";
        }
        for (File file : SchematicLoader.currentSchematicFiles()) {
            if (!file.getPath().endsWith(name) || !name.endsWith(file.getName())) continue;
            return SchematicLoader.loadSchematicFromFile(file);
        }
        return null;
    }

    public static SchematicFile loadSchematicFromFile(File file) throws SchematicFile.UnsupportedSchematicFormatException {
        Throwable throwable;
        FileInputStream fileInputStream;
        NBTTagCompound compound = null;
        Exception exception = null;
        try {
            fileInputStream = new FileInputStream(file);
            throwable = null;
            try {
                compound = CompressedStreamTools.func_74796_a((InputStream)fileInputStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fileInputStream != null) {
                    if (throwable != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        fileInputStream.close();
                    }
                }
            }
        }
        catch (Exception e) {
            exception = e;
        }
        if (compound == null) {
            try {
                fileInputStream = new FileInputStream(file);
                throwable = null;
                try {
                    DataInputStream datainputstream = new DataInputStream(new BufferedInputStream(fileInputStream));
                    compound = CompressedStreamTools.func_74794_a((DataInputStream)datainputstream);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (fileInputStream != null) {
                        if (throwable != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            fileInputStream.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new SchematicFile.UnsupportedSchematicFormatException(exception, "Not a compressed NBT file");
            }
        }
        if (compound != null) {
            return new SchematicFile(compound);
        }
        return null;
    }

    public static void writeSchematicByName(SchematicFile schematic, String name) {
        SchematicLoader.writeSchematicToFile(schematic, new File(SchematicLoader.getValidatedSchematicsFile(), name + ".schematic"));
    }

    public static void writeSchematicToFile(SchematicFile schematic, File file) {
        NBTTagCompound compound = new NBTTagCompound();
        schematic.writeToNBT(compound);
        try (DataOutputStream dataOutputStream = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(file)));){
            RCAccessorNBT.writeEntry("Schematic", (NBTBase)compound, dataOutputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<String> currentSchematicFileNames() {
        return SchematicLoader.currentSchematicFiles().stream().map(file -> FilenameUtils.getBaseName((String)file.getName())).collect(Collectors.toList());
    }

    public static Collection<File> currentSchematicFiles() {
        File schematicsFile = SchematicLoader.getValidatedSchematicsFile();
        return schematicsFile != null ? FileUtils.listFiles((File)schematicsFile, (String[])new String[]{"schematic"}, (boolean)true) : Collections.emptyList();
    }

    public static String getLookupFolderName() {
        return "structures/schematics";
    }

    public static File getValidatedSchematicsFile() {
        File structuresFile = IvFileHelper.getValidatedFolder((File)new File(RecurrentComplex.proxy.getDataDirectory(), "structures"));
        return structuresFile != null ? IvFileHelper.getValidatedFolder((File)structuresFile, (String)"schematics") : null;
    }
}

