/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils.expression;

import ivorius.reccomplex.utils.algebra.FunctionExpressionCache;
import ivorius.reccomplex.utils.algebra.SupplierCache;
import ivorius.reccomplex.utils.expression.PreloadedBooleanExpression;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;

public class Expressions {
    public static PreloadedBooleanExpression<EnumFacing> direction() {
        return PreloadedBooleanExpression.with(exp -> {
            exp.addConstants(EnumFacing.values());
            exp.addEvaluators(axis -> facing -> facing.func_176740_k() == axis, EnumFacing.Axis.values());
            exp.addEvaluator("horizontal", f -> f.func_176736_b() >= 0);
            exp.addEvaluator("vertical", f -> f.func_176736_b() < 0);
        });
    }

    public static List<EnumFacing> directions(PreloadedBooleanExpression<EnumFacing> facingExpression) {
        return Arrays.stream(EnumFacing.values()).filter(facingExpression).collect(Collectors.toList());
    }

    public static <T> FunctionExpressionCache.VariableType<Boolean, T, Object> dictionaryVariableType(String prefix, String suffix, final Function<String, T> converter, final Predicate<String> known) {
        return new FunctionExpressionCache.VariableType<Boolean, T, Object>(prefix, suffix){

            @Override
            public Function<SupplierCache<T>, Boolean> parse(String var) throws ParseException {
                Object t = converter.apply(var);
                return t != null ? v -> v.get() == t : b -> false;
            }

            @Override
            public FunctionExpressionCache.Validity validity(String var, Object o) {
                return known.test(var) ? FunctionExpressionCache.Validity.KNOWN : FunctionExpressionCache.Validity.UNKNOWN;
            }
        };
    }

    public static <T> FunctionExpressionCache.VariableType<Boolean, T, Object> registryVariableType(String prefix, String suffix, RegistryNamespaced<ResourceLocation, T> registry) {
        return Expressions.dictionaryVariableType(prefix, suffix, s -> registry.func_82594_a((Object)new ResourceLocation(s)), s -> registry.func_148741_d((Object)new ResourceLocation(s)));
    }
}

