/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils.expression;

import ivorius.reccomplex.files.loading.LeveledRegistry;
import ivorius.reccomplex.files.saving.FileSaver;
import ivorius.reccomplex.utils.algebra.BoolFunctionExpressionCache;
import ivorius.reccomplex.utils.algebra.ExpressionCache;
import ivorius.reccomplex.utils.algebra.FunctionExpressionCache;
import ivorius.reccomplex.utils.algebra.RCBoolAlgebra;
import ivorius.reccomplex.utils.algebra.SupplierCache;
import ivorius.reccomplex.utils.expression.DelegatingVariableType;
import ivorius.reccomplex.utils.expression.RegistryExpression;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.tuple.Pair;

public class DependencyExpression
extends BoolFunctionExpressionCache<FileSaver, FileSaver> {
    public static final String MOD_PREFIX = "mod:";
    public static final String REGISTRY_PREFIX = "registry:";

    public DependencyExpression() {
        super(RCBoolAlgebra.algebra(), true, TextFormatting.GREEN + "No Dependencies");
        this.addTypes(new ModVariableType(MOD_PREFIX, ""), t -> t.alias("$", ""));
        this.addTypes(new RegistryVariableType(REGISTRY_PREFIX, ""), t -> t.alias("reg:", ""));
        this.addTypes(new RegistryHasVariableType("structure:", "", "structure"), t -> t.alias("#", ""), t -> t.alias("strc:", ""));
    }

    public static String ofMods(String ... ids) {
        return ids.length > 0 ? MOD_PREFIX + String.join((CharSequence)" & mod:", Arrays.asList(ids)) : "";
    }

    protected static class RegistryVariableType
    extends DelegatingVariableType<Boolean, FileSaver, FileSaver, LeveledRegistry, LeveledRegistry, RegistryExpression> {
        public RegistryVariableType(String prefix, String suffix) {
            super(prefix, suffix);
        }

        public static Optional<Pair<String, String>> splitOnce(String var, String split) {
            int index = var.indexOf(split);
            return index >= 0 ? Optional.of(Pair.of((Object)var.substring(0, index), (Object)var.substring(index + 1, var.length()))) : Optional.empty();
        }

        @Override
        public FunctionExpressionCache.Validity validity(String var, FileSaver fileSaver) {
            return !RegistryVariableType.splitOnce(var, ".").isPresent() ? FunctionExpressionCache.Validity.ERROR : super.validity(var, fileSaver);
        }

        @Override
        protected String getVarRepresentation(String var, FileSaver fileSaver) {
            return RegistryVariableType.splitOnce(var, ".").map(p -> TextFormatting.BLUE + (String)p.getLeft() + TextFormatting.YELLOW + "." + TextFormatting.RESET + super.getVarRepresentation(var, fileSaver)).orElse(this.getRepresentation(FunctionExpressionCache.Validity.ERROR) + var);
        }

        @Override
        public RegistryExpression createCache() {
            return new RegistryExpression();
        }

        @Override
        public Function<SupplierCache<FileSaver>, Boolean> parse(String var) throws ParseException {
            Optional<Pair<String, String>> split = RegistryVariableType.splitOnce(var, ".");
            return split.map(p -> {
                RegistryExpression c = ExpressionCache.of(this.createCache(), (String)p.getRight());
                return fileSaver -> (Boolean)c.evaluate(this.convertEvaluateArgument(var, fileSaver.get()));
            }).orElseThrow(IllegalStateException::new);
        }

        @Override
        public LeveledRegistry convertArgument(String var, FileSaver fileSaver) {
            return RegistryVariableType.splitOnce(var, ".").map(p -> fileSaver.registry((String)p.getLeft())).orElseThrow(IllegalStateException::new);
        }
    }

    protected static class RegistryHasVariableType
    extends FunctionExpressionCache.VariableType<Boolean, FileSaver, FileSaver> {
        public String registryID;

        public RegistryHasVariableType(String prefix, String suffix, String registry) {
            super(prefix, suffix);
            this.registryID = registry;
        }

        @Override
        public Function<SupplierCache<FileSaver>, Boolean> parse(String var) throws ParseException {
            return saver -> ((FileSaver)saver.get()).registry(this.registryID).has(var);
        }

        @Override
        public FunctionExpressionCache.Validity validity(String var, FileSaver saver) {
            return !saver.has(this.registryID) ? FunctionExpressionCache.Validity.ERROR : (saver.registry(this.registryID).has(var) ? FunctionExpressionCache.Validity.KNOWN : FunctionExpressionCache.Validity.UNKNOWN);
        }
    }

    protected static class ModVariableType
    extends FunctionExpressionCache.VariableType<Boolean, Object, Object> {
        public ModVariableType(String prefix, String suffix) {
            super(prefix, suffix);
        }

        @Override
        public Function<SupplierCache<Object>, Boolean> parse(String var) throws ParseException {
            boolean modLoaded = Loader.isModLoaded((String)var);
            return a -> modLoaded;
        }

        @Override
        public FunctionExpressionCache.Validity validity(String var, Object args) {
            return Loader.isModLoaded((String)var) ? FunctionExpressionCache.Validity.KNOWN : FunctionExpressionCache.Validity.UNKNOWN;
        }
    }
}

