/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.random;

import ivorius.ivtoolkit.strings.LayeredStringGenerator;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class Person {
    private static final LayeredStringGenerator chaoticNameGen;
    public static List<String> nordicNamesMale;
    public static List<String> nordicNamesFemale;
    private String firstName;
    private String middleName;
    private String lastName;

    public Person(String firstName, String middleName, String lastName) {
        this.firstName = firstName;
        this.middleName = middleName;
        this.lastName = lastName;
    }

    public static Person randomHuman(Random random, boolean male) {
        NameType nameType = random.nextFloat() < 0.95f ? NameType.NORDIC : NameType.CHAOTIC;
        return Person.randomPerson(random, male, nameType);
    }

    public static Person randomPerson(Random random, boolean male, NameType type) {
        switch (type) {
            case CHAOTIC: {
                return Person.randomChaoticPerson(random, male);
            }
            case NORDIC: {
                return Person.randomNordicPerson(random, male);
            }
        }
        throw new RuntimeException();
    }

    private static Person randomChaoticPerson(Random random, boolean male) {
        return new Person(Person.chaoticName(random, male), random.nextFloat() < 0.15f ? Person.chaoticName(random, male) : null, random.nextFloat() < 0.4f ? Person.chaoticName(random, male) : null);
    }

    private static Person randomNordicPerson(Random random, boolean male) {
        String middleName;
        String string = middleName = random.nextFloat() < 0.3f ? Person.nordicName(random, male) : null;
        String lastName = random.nextFloat() < 0.95f ? Person.nordicLastName(random, male, random.nextFloat() < 0.1f) : null;
        return new Person(Person.nordicName(random, male), middleName, lastName);
    }

    public static String nordicName(Random random, boolean male) {
        return male ? Person.getRandomElementFrom(nordicNamesMale, random) : Person.getRandomElementFrom(nordicNamesFemale, random);
    }

    public static String nordicLastName(Random random, boolean male, boolean parentMale) {
        return Person.nordicName(random, parentMale) + (male ? "sson" : "sdottir");
    }

    public static String chaoticName(Random random, boolean male) {
        return chaoticNameGen.randomString(random);
    }

    private static <O> O getRandomElementFrom(List<O> list, Random random) {
        return list.get(random.nextInt(list.size()));
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFullName() {
        StringBuilder builder = new StringBuilder();
        if (this.firstName != null) {
            builder.append(this.firstName);
        }
        if (this.middleName != null) {
            builder.append(' ').append(this.middleName);
        }
        if (this.lastName != null) {
            builder.append(' ').append(this.lastName);
        }
        return builder.toString().trim();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Person person = (Person)o;
        if (this.firstName != null ? !this.firstName.equals(person.firstName) : person.firstName != null) {
            return false;
        }
        if (this.middleName != null ? !this.middleName.equals(person.middleName) : person.middleName != null) {
            return false;
        }
        return this.lastName != null ? this.lastName.equals(person.lastName) : person.lastName == null;
    }

    public int hashCode() {
        int result = this.firstName != null ? this.firstName.hashCode() : 0;
        result = 31 * result + (this.middleName != null ? this.middleName.hashCode() : 0);
        result = 31 * result + (this.lastName != null ? this.lastName.hashCode() : 0);
        return result;
    }

    static {
        LayeredStringGenerator.LayerStatic vowels = new LayeredStringGenerator.LayerStatic(new String[]{"a", "e", "i", "o", "u", "ei", "ai", "ou", "j", "ji", "y", "oi", "au", "oo"});
        LayeredStringGenerator.LayerStatic startConsonants = new LayeredStringGenerator.LayerStatic(new String[]{"b", "c", "d", "f", "g", "h", "k", "l", "m", "n", "p", "q", "r", "s", "t", "v", "w", "x", "z", "ch", "bl", "br", "fl", "gl", "gr", "kl", "pr", "st", "sh", "th"});
        LayeredStringGenerator.LayerStatic endConsonants = new LayeredStringGenerator.LayerStatic(new String[]{"b", "d", "f", "g", "h", "k", "l", "m", "n", "p", "r", "s", "t", "v", "w", "z", "ch", "gh", "nn", "st", "sh", "th", "tt", "ss", "pf", "nt"});
        LayeredStringGenerator.LayerSimple chaoticWord = new LayeredStringGenerator.LayerSimple(new Object[]{Character.valueOf('c'), startConsonants, Character.valueOf('v'), vowels, Character.valueOf('d'), endConsonants});
        chaoticWord.addStrings(1.0, new String[]{"vdv", "cvdvd", "cvd", "vdvd"});
        LayeredStringGenerator.LayerSimple baseChaoticName = new LayeredStringGenerator.LayerSimple(new Object[]{Character.valueOf('n'), new LayeredStringGenerator.LayerUppercase((LayeredStringGenerator.Layer)chaoticWord)});
        baseChaoticName.addStrings(4.0, new String[]{"n"});
        baseChaoticName.addStrings(1.0, new String[]{"n-n"});
        chaoticNameGen = new LayeredStringGenerator((LayeredStringGenerator.Layer)baseChaoticName);
        nordicNamesMale = Arrays.asList("Erik", "Magnus", "John", "William", "Lukas", "Elias", "Malik", "Aron", "Enuk", "Christian", "Peter", "Hans", "Jens", "Niels", "Kristian", "Aage", "Johannes", "Carl", "Svend", "Sven", "Jakup", "Benjamin", "Danjal", "Hanus", "Rei", "Simun", "Bardur", "Johan", "Jonas", "Aleksi", "Ville", "Niko", "Juho", "Teemu", "Joonas", "Jesse", "Joni", "Jere", "Antti", "Ole", "Lars", "Jorgen", "Jakob", "Jon", "Daniel", "Sigurdur", "Arnar", "Kristofer", "Einar", "Gunnar", "Alexander", "Andri", "Viktor", "Olof", "Lennart", "Pall");
        nordicNamesFemale = Arrays.asList("Emma", "Eva", "Sofia", "Pipaluk", "Emilia", "Alice", "Marie", "Anna", "Margrethe", "Kristine", "Johanne", "Karen", "Elisabeth", "Ellen", "Ingeborg", "Rebekka", "Helena", "Vir", "Ronja", "Katrin", "Liv", "Maria", "Sara", "Jenna", "Laura", "Roosa", "Veera", "Emilia", "Julia", "Sara", "Jenni", "Noora", "Ane", "Johanne", "Dorthe", "Margrethe", "Sofie", "Else", "Amalie", "Gudrun", "Helga", "Birta", "Maria");
    }

    public static enum NameType {
        NORDIC,
        CHAOTIC;

    }
}

