/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.worldscripts.mazegenerator;

import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.client.rendering.MazeVisualizationContext;
import ivorius.reccomplex.gui.TableDataSourceBlockPos;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCellMultiBuilder;
import ivorius.reccomplex.gui.table.cell.TableCellString;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.gui.worldscripts.TableDataSourceWorldScript;
import ivorius.reccomplex.gui.worldscripts.mazegenerator.TableDataSourceMazeComponent;
import ivorius.reccomplex.gui.worldscripts.mazegenerator.TableDataSourceMazeInfo;
import ivorius.reccomplex.gui.worldscripts.mazegenerator.rules.TableDataSourceMazeRuleList;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.MazeGeneration;
import ivorius.reccomplex.world.gen.script.WorldScriptMazeGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TableDataSourceWorldScriptMazeGenerator
extends TableDataSourceSegmented {
    private WorldScriptMazeGenerator script;
    protected TableDelegate delegate;
    protected TableNavigator navigator;

    public TableDataSourceWorldScriptMazeGenerator(WorldScriptMazeGenerator script, BlockPos realWorldPos, TableDelegate delegate, TableNavigator navigator) {
        this.script = script;
        this.delegate = delegate;
        this.navigator = navigator;
        this.addSegment(0, new TableDataSourceWorldScript(script));
        this.addSegment(1, () -> TableCellMultiBuilder.create(navigator, delegate).addCell(() -> {
            TableCellString cell = new TableCellString("mazeID", script.getMazeID());
            cell.setShowsValidityState(true);
            cell.setValidityState(MazeGeneration.idValidity((String)cell.getPropertyValue()));
            cell.addListener(mazeID -> {
                script.setMazeID((String)mazeID);
                cell.setValidityState(MazeGeneration.idValidity(mazeID));
            });
            return cell;
        }).addNavigation(() -> new TableDataSourceMazeInfo(script, delegate, navigator)).withTitle(IvTranslations.get((String)"reccomplex.maze.id")).build());
        this.addSegment(2, TableCellMultiBuilder.create(navigator, delegate).addNavigation(() -> new TableDataSourceMazeComponent(script.mazeComponent, navigator, delegate).visualizing(new MazeVisualizationContext(script.structureShift.func_177971_a((Vec3i)realWorldPos), script.roomSize)), () -> IvTranslations.get((String)"reccomplex.maze")).withTitle("").buildDataSource());
        this.addSegment(3, TableCellMultiBuilder.create(navigator, delegate).addNavigation(() -> new TableDataSourceMazeRuleList(script.rules, delegate, navigator, script.mazeComponent.exitPaths, script.mazeComponent.rooms), () -> IvTranslations.get((String)"reccomplex.worldscript.mazeGen.rules")).withTitle("").buildDataSource());
        this.addSegment(4, new TableDataSourceBlockPos(script.getStructureShift(), script::setStructureShift, IvTranslations.get((String)"reccomplex.gui.blockpos.shift"), IvTranslations.getLines((String)"reccomplex.gui.blockpos.shift.tooltip")));
    }

    public WorldScriptMazeGenerator getScript() {
        return this.script;
    }

    public void setScript(WorldScriptMazeGenerator script) {
        this.script = script;
    }

    public TableDelegate getTableDelegate() {
        return this.delegate;
    }

    public void setTableDelegate(TableDelegate tableDelegate) {
        this.delegate = tableDelegate;
    }

    public TableNavigator getNavigator() {
        return this.navigator;
    }

    public void setNavigator(TableNavigator navigator) {
        this.navigator = navigator;
    }
}

