/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.worldscripts.mazegenerator;

import com.google.common.collect.Iterables;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.client.rendering.MazeVisualizationContext;
import ivorius.reccomplex.client.rendering.SelectionQuadCache;
import ivorius.reccomplex.gui.GuiHider;
import ivorius.reccomplex.gui.TableDirections;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCellButton;
import ivorius.reccomplex.gui.table.cell.TableCellEnum;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.gui.worldscripts.mazegenerator.TableDataSourceMazeRoom;
import ivorius.reccomplex.world.gen.feature.structure.generic.Selection;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.SavedMazePath;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.SavedMazePathConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TableDataSourceMazePath
extends TableDataSourceSegmented {
    public static final String[] COORD_NAMES = new String[]{"x", "y", "z"};
    private SavedMazePath mazePath;
    private Selection bounds;
    private TableDelegate tableDelegate;
    private TableCellButton invertableButton;
    private final TableDataSourceMazeRoom source;
    protected MazeVisualizationContext visualizationContext;

    public TableDataSourceMazePath(SavedMazePath mazePath, Selection bounds, TableDelegate tableDelegate, TableNavigator navigator) {
        this.mazePath = mazePath;
        this.bounds = bounds;
        this.tableDelegate = tableDelegate;
        this.source = new TableDataSourceMazeRoom(mazePath.sourceRoom, mazeRoom -> {
            this.mazePath.sourceRoom = mazeRoom;
            if (this.invertableButton != null) {
                this.invertableButton.setEnabled(this.isInvertable());
            }
        }, bounds.bounds(), Arrays.stream(COORD_NAMES).map(s -> IvTranslations.get((String)("reccomplex.generationInfo.mazeComponent.position." + s))).collect(Collectors.toList()), Arrays.stream(COORD_NAMES).map(s -> IvTranslations.getLines((String)("reccomplex.generationInfo.mazeComponent.position." + s + ".tooltip"))).collect(Collectors.toList()));
        this.addSegment(0, this.source);
        this.addSegment(1, () -> {
            TableCellEnum.Option<EnumFacing>[] optionList = TableDirections.getDirectionOptions(EnumFacing.field_82609_l);
            TableCellEnum<EnumFacing> cell = new TableCellEnum<EnumFacing>("side", TableDataSourceMazePath.directionFromPath(mazePath), optionList);
            cell.addListener(val -> {
                SavedMazePathConnection path = TableDataSourceMazePath.pathFromDirection(val, mazePath.sourceRoom.getCoordinates());
                mazePath.pathDimension = path.path.pathDimension;
                mazePath.pathGoesUp = path.path.pathGoesUp;
                tableDelegate.reloadData();
            });
            return new TitledCell(IvTranslations.get((String)"reccomplex.generationInfo.mazeComponent.path.side"), cell);
        });
        this.addSegment(2, () -> {
            this.invertableButton = new TableCellButton("actions", "inverse", IvTranslations.get((String)"reccomplex.generationInfo.mazeComponent.path.invert"), this.isInvertable());
            this.invertableButton.addAction(() -> {
                mazePath.set(mazePath.inverse());
                this.source.room = mazePath.sourceRoom;
                tableDelegate.reloadData();
            });
            return new TitledCell(this.invertableButton);
        });
    }

    public static boolean contains(int[] array, Selection bounds) {
        return bounds.compile(true).containsKey(new MazeRoom(array));
    }

    public static EnumFacing directionFromPath(SavedMazePath path) {
        switch (path.pathDimension) {
            case 0: {
                return path.pathGoesUp ? EnumFacing.EAST : EnumFacing.WEST;
            }
            case 1: {
                return path.pathGoesUp ? EnumFacing.UP : EnumFacing.DOWN;
            }
            case 2: {
                return path.pathGoesUp ? EnumFacing.SOUTH : EnumFacing.NORTH;
            }
        }
        return null;
    }

    public static SavedMazePathConnection pathFromDirection(EnumFacing side, int[] room) {
        int pathDim = side.func_82601_c() != 0 ? 0 : (side.func_96559_d() != 0 ? 1 : (side.func_82599_e() != 0 ? 2 : -1));
        int offset = side.func_82601_c() + side.func_96559_d() + side.func_82599_e();
        return new SavedMazePathConnection(pathDim, new MazeRoom(new int[]{room[0], room[1], room[2]}), offset > 0, "Path", Collections.emptyList());
    }

    public static void addToSelection(Selection selection, SavedMazePath path) {
        selection.add(Selection.Area.from(true, path.sourceRoom.getCoordinates(), path.sourceRoom.getCoordinates(), "s"));
        selection.add(Selection.Area.from(true, path.getDestRoom().getCoordinates(), path.getDestRoom().getCoordinates(), "d"));
    }

    @Nonnull
    public static GuiHider.Visualizer visualizePaths(MazeVisualizationContext visualizationContext, Collection<SavedMazePath> mazePaths) {
        if (mazePaths.size() <= 0) {
            return new SelectionQuadCache.Visualizer(new Selection(0), visualizationContext);
        }
        Selection selection = new Selection(((SavedMazePath)Iterables.getFirst(mazePaths, null)).sourceRoom.getDimensions());
        mazePaths.forEach(p -> TableDataSourceMazePath.addToSelection(selection, p));
        return new SelectionQuadCache.Visualizer(selection, visualizationContext);
    }

    public TableDataSourceMazePath visualizing(MazeVisualizationContext context) {
        this.visualizationContext = context;
        return this;
    }

    @Override
    @Nonnull
    public String title() {
        return "Path";
    }

    protected boolean isInvertable() {
        return TableDataSourceMazePath.contains(this.mazePath.inverse().getSourceRoom().getCoordinates(), this.bounds);
    }

    @Override
    public boolean canVisualize() {
        return this.visualizationContext != null;
    }

    @Override
    public GuiHider.Visualizer visualizer() {
        return TableDataSourceMazePath.visualizePaths(this.visualizationContext, Collections.singletonList(this.mazePath));
    }
}

