/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.nbt;

import ivorius.reccomplex.gui.nbt.TableDataSourceNBT;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellButton;
import ivorius.reccomplex.gui.table.cell.TableCellMulti;
import ivorius.reccomplex.gui.table.cell.TableCellPresetAction;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TableDataSourceNBTList
extends TableDataSourceSegmented {
    protected TableDelegate delegate;
    protected TableNavigator navigator;
    protected NBTTagList nbt;
    protected String earlierTitle = TextFormatting.BOLD + "\u2191";
    protected String laterTitle = TextFormatting.BOLD + "\u2193";
    protected String deleteTitle = TextFormatting.RED + "-";
    protected String addTitle = TextFormatting.GREEN + "+";

    public TableDataSourceNBTList(TableDelegate delegate, TableNavigator navigator, NBTTagList nbt) {
        this.delegate = delegate;
        this.navigator = navigator;
        this.nbt = nbt;
    }

    public String getEarlierTitle() {
        return this.earlierTitle;
    }

    public void setEarlierTitle(String earlierTitle) {
        this.earlierTitle = earlierTitle;
    }

    public String getLaterTitle() {
        return this.laterTitle;
    }

    public void setLaterTitle(String laterTitle) {
        this.laterTitle = laterTitle;
    }

    public String getDeleteTitle() {
        return this.deleteTitle;
    }

    public void setDeleteTitle(String deleteTitle) {
        this.deleteTitle = deleteTitle;
    }

    public String getAddTitle() {
        return this.addTitle;
    }

    public void setAddTitle(String addTitle) {
        this.addTitle = addTitle;
    }

    @Override
    @Nonnull
    public String title() {
        return "NBT List";
    }

    @Override
    public int numberOfSegments() {
        return 4;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return segment == 2 ? this.nbt.func_74745_c() : 1;
    }

    @Override
    public TableCell cellForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 0) {
            return new TableCellPresetAction(null, IntStream.range(0, 12).mapToObj(id -> TableDataSourceNBT.typeButton(id, () -> {
                while (!this.nbt.func_82582_d()) {
                    this.nbt.func_74744_a(this.nbt.func_74745_c() - 1);
                }
                ReflectionHelper.setPrivateValue(NBTTagList.class, (Object)this.nbt, (Object)((byte)id), (String)"tagType", (String)"field_74746_b");
                this.delegate.reloadData();
            })).collect(Collectors.toList()));
        }
        if (segment == 1 || segment == 3) {
            return TableDataSourceNBT.addButton(this.nbt.func_150303_d(), n -> {
                if (segment == 1) {
                    ArrayList<NBTBase> cur = new ArrayList<NBTBase>(this.nbt.func_74745_c());
                    while (!this.nbt.func_82582_d()) {
                        cur.add(this.nbt.func_74744_a(this.nbt.func_74745_c() - 1));
                    }
                    this.nbt.func_74742_a(n);
                    for (NBTBase prev : cur) {
                        this.nbt.func_74742_a(prev);
                    }
                } else {
                    this.nbt.func_74742_a(n);
                }
                this.delegate.reloadData();
            });
        }
        if (segment == 2) {
            TableCellMulti multi = new TableCellMulti(this.getEntryActions(index));
            multi.setSize(0, 8.0f);
            return new TitledCell("" + index, multi);
        }
        return super.cellForIndexInSegment(table, index, segment);
    }

    public List<TableCell> getEntryActions(int index) {
        boolean enabled = true;
        NBTBase cellNBT = this.nbt.func_179238_g(index);
        TableCell entryCell = TableDataSourceNBT.cell(cellNBT, this.delegate, this.navigator);
        TableCellButton earlier = new TableCellButton("", "earlier", this.getEarlierTitle(), index > 0 && enabled);
        earlier.addAction(() -> {
            this.nbt.func_150304_a(index, this.nbt.func_179238_g(index - 1));
            this.nbt.func_150304_a(index - 1, cellNBT);
            this.delegate.reloadData();
        });
        TableCellButton later = new TableCellButton("", "later", this.getLaterTitle(), index < this.nbt.func_74745_c() - 1 && enabled);
        later.addAction(() -> {
            this.nbt.func_150304_a(index, this.nbt.func_179238_g(index + 1));
            this.nbt.func_150304_a(index + 1, cellNBT);
            this.delegate.reloadData();
        });
        TableCellButton delete = new TableCellButton("", "delete", this.getDeleteTitle(), enabled);
        delete.addAction(() -> {
            this.nbt.func_74744_a(index);
            this.delegate.reloadData();
        });
        return Arrays.asList(entryCell, earlier, later, delete);
    }
}

